package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.variables.ListOfStringValueProviderConfiguration
import com.xebialabs.xlrelease.domain.variables.ListStringVariable
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration
import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.dsl.service.DslError
import com.xebialabs.xlrelease.variable.VariableHelper
import groovy.transform.TypeChecked

@TypeChecked
abstract class VariableWithValueProviderSpec<T extends Variable> extends VariableSpec<T> {
  private List<Variable> createdVariables
  private Type valueProviderType
  private List<String> valueProviderPossibleValues
  private String valueProviderVarRef

  VariableWithValueProviderSpec(final String name, final Class<T> clazz, List<Variable> createdVariables) {
    super(name, clazz)
    this.createdVariables = createdVariables
    this.possibleValues()
  }

  void valueProvider(String valueProviderType) {
    this.valueProviderType = Type.valueOf(valueProviderType)
  }

  void possibleValues(String... values) {
    valueProviderPossibleValues = values.toList()
  }

  @NoDoc
  void possibleValues(VariableRefSpec varRef) {
    valueProviderVarRef = VariableHelper.formatVariableIfNeeded(varRef.variableName)
  }

  @NoDoc
  VariableRefSpec variable(String variableName) {
    new VariableRefSpec(variableName)
  }

  @NoDoc
  @Override
  protected void postProcess() {
    super.postProcess()

    if (valueProviderType == null) {
      valueProviderType = Type.valueOf(ListOfStringValueProviderConfiguration)
    }
    def valueProvider = valueProviderType.getDescriptor().<ValueProviderConfiguration> newInstance(null)

    if (valueProvider.getType().instanceOf(Type.valueOf(ListOfStringValueProviderConfiguration))) {
      if (valueProviderVarRef != null) {
        ((ListOfStringValueProviderConfiguration) valueProvider).setVariableKey(valueProviderVarRef)
        if (!VariableHelper.isGlobalOrFolderVariable(valueProviderVarRef)) {
          assertReleaseVariableIsAList(valueProviderVarRef)
        }
      } else if (valueProviderPossibleValues != null && !valueProviderPossibleValues.isEmpty()) {
        ((ListOfStringValueProviderConfiguration) valueProvider).setValues(valueProviderPossibleValues)
      }
    }

    configurationItem.setValueProvider(valueProvider)
  }

  private void assertReleaseVariableIsAList(String variableKey) {
    Variable referencedVariable = createdVariables.find { it.key == VariableHelper.withoutVariableSyntax(variableKey) }
    if (referencedVariable == null) {
      throw new DslError("Variable '${variableKey}' has to be defined before the list box variable ${configurationItem.key} that uses it")
    }
    if (!referencedVariable.getType().instanceOf(Type.valueOf(ListStringVariable))) {
      throw new DslError("Variable '${variableKey}' is not a listVariable")
    }
  }
}