package com.xebialabs.xlrelease.dsl

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.dsl.service.DslService
import groovy.transform.TypeChecked
import org.slf4j.Logger

import static com.xebialabs.xlrelease.repository.IdType.DOMAIN

@TypeChecked
class XlrSpec {

  private DslService dslService
  private Logger logger
  private Release parentRelease
  private Task executingTask
  private Object context

  XlrSpec(Object context, Release parentRelease, Task executingTask, DslService dslService, Logger logger) {
    this.context = context
    this.dslService = dslService
    this.parentRelease = parentRelease
    this.executingTask = executingTask
    this.logger = logger
  }

  /**
   * Creates a Release with title and properties.
   *
   * @see #release(groovy.lang.Closure)
   */
  Release release(String title = null, @DelegatesTo(value = ReleaseSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    def releaseSpec = new ReleaseSpec(title)
    Release release = ReleaseSpec.delegate(releaseSpec, cl)

    logger.info "created release in memory"
    Release createdRelease = dslService.createRelease(parentRelease, release, releaseSpec.getAdditionalProperties())
    logger.info "created release in repository"
    // Log a markdown link on the output for easy navigation from GUI
    context.println("Created release [${createdRelease.getTitle()}](#/releases/${DOMAIN.convertToViewId(createdRelease.getId())}).")
    createdRelease
  }

  /**
   * Creates a Template with title and properties.
   *
   * @see #template(groovy.lang.Closure)
   */
  Release template(String title = null, @DelegatesTo(value = TemplateSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    def templateSpec = new TemplateSpec(title)
    Release template = TemplateSpec.delegate(templateSpec, cl)

    logger.info "created template in memory"
    Release createdTemplate = dslService.createTemplate(parentRelease, template, templateSpec.getAdditionalProperties())
    logger.info "created template in repository"
    // Log a markdown link on the output for easy navigation from GUI
    context.println("Created template [${createdTemplate.getTitle()}](#/templates/${DOMAIN.convertToViewId(createdTemplate.getId())}).")
    createdTemplate
  }

}
