package com.xebialabs.xlrelease.dsl

import com.xebialabs.xlrelease.domain.Phase
import com.xebialabs.xlrelease.domain.Release
import groovy.transform.TypeChecked

/**
 * DSL representation for a collection of Phase
 */
@TypeChecked
class PhasesDelegate extends CollectionDelegate<Release, Phase> {
  PhasesDelegate(Release container) {
    super(container)
  }

  /**
   * Creates a Phase with title and properties inside phases for a Release.
   */
  PhaseSpec phase(String title = null, @DelegatesTo(value = PhaseSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new PhaseSpec(title), cl)
  }

}