package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.CustomScriptTask
import com.xebialabs.xlrelease.domain.PythonScript
import groovy.transform.TypeChecked

@TypeChecked
class CustomScriptTaskSpec extends TaskSpec<CustomScriptTask> {

  CustomScriptTaskSpec(String title = null) {
    super(title, Type.valueOf(CustomScriptTask))
  }

  void script(@DelegatesTo(value = ScriptDelegateSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    CustomScriptTask customScriptTask = this.configurationItem
    def scriptSpec = new ScriptDelegateSpec<PythonScript>(customScriptTask)
    PythonScript script = scriptSpec.delegate(scriptSpec, cl)
    customScriptTask.setPythonScript(script)
    script.setCustomScriptTask(customScriptTask)
    scriptSpec.variableReferences.each { varRef ->
      this.variableReferences.add(new VariableRefSpec("pythonScript.${varRef.propertyName}", varRef.variableName))
    }
  }
}
