package com.xebialabs.xlrelease.domain;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.variable.ValueWithInterpolation;

import static java.util.Arrays.asList;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label = "Script: Groovy Script / Releasefile", versioned = false)
public class GroovyScriptTask extends ScriptTask {

    public static final String GROOVY_ENGINE = "groovy";

    @Override
    public String getEngine() {
        return GROOVY_ENGINE;
    }

    @Override
    public Set<String> freezeVariablesInCustomFields(Map<String, ValueWithInterpolation> variables,
                                                     Map<String, String> passwordVariables,
                                                     Changes changes,
                                                     boolean freezeEvenIfUnresolved) {
        return Collections.emptySet();
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        return asList(
                new PropertyUsagePoint(this, "title"),
                new PropertyUsagePoint(this, "description"),
                new PropertyUsagePoint(this, "owner"),
                new PropertyUsagePoint(this, "precondition")
        );
    }

    @Override
    public boolean isScriptInterpolationOff() {
        return true;
    }

}
