package com.xebialabs.xlrelease.dsl

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.Team
import groovy.transform.TypeChecked

/**
 * DSL representation for a collection of Teams
 */
@TypeChecked
class TeamsDelegate extends CollectionDelegate<Release, Team> {
  TeamsDelegate(Release container) {
    super(container)
  }

  /**
   * Creates a Team with title, members, roles and permissions.
   */
  TeamSpec team(String teamName = null, @DelegatesTo(value = TeamSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new TeamSpec(teamName), cl)
  }
}