package com.xebialabs.xlrelease.dsl

import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable
import groovy.transform.TypeChecked

@TypeChecked
class PasswordStringVariableSpec extends VariableSpec<PasswordStringVariable> {

  PasswordStringVariableSpec(String name = null) {
    super(name, PasswordStringVariable)
  }

  void value(String value) {
    configurationItem.value = value
  }

  @NoDoc
  void externalVariableValue(@DelegatesTo(value = ExternalVariableValueSpec, strategy = Closure.OWNER_FIRST) Closure cl) {
    def externalVariableValueSpec = new ExternalVariableValueSpec()
    externalVariableValueSpec.delegate(externalVariableValueSpec, cl)
    configurationItem.setExternalVariableValue(externalVariableValueSpec.configurationItem)
  }

}