package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.NotificationTask
import com.xebialabs.xlrelease.domain.notification.MailPriority
import groovy.transform.TypeChecked

@TypeChecked
class NotificationTaskSpec extends TaskSpec<NotificationTask> {

  NotificationTaskSpec(String title = null) {
    super(title, Type.valueOf(NotificationTask))
  }

  void addresses(String ... addresses) {
    configurationItem.addresses = addresses.toList().toSet()
  }

  void priority(MailPriority priority) {
    configurationItem.priority = priority
  }

  void cc(String ... cc) {
    configurationItem.cc = cc.toList().toSet()
  }

  void bcc(String ... bcc) {
    configurationItem.bcc = bcc.toList().toSet()
  }

  void replyTo(String replyTo) {
    configurationItem.replyTo = replyTo
  }

  void from(String from) {
    configurationItem.from = from
  }

  void senderUsername(String username) {
    configurationItem.senderUsername = username
  }

  void senderPassword(String password) {
    configurationItem.senderPassword = password
  }

  void subject(String subject) {
    configurationItem.subject = subject
  }

  void body(String body) {
    configurationItem.body = body
  }

}
