package com.xebialabs.xlrelease.dsl.service;

import java.util.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

@Primary
@Component
public class DslCiProcessor implements CiProcessor {
    private Map<Type, CiProcessor> processorMap = new HashMap<>();

    @Autowired
    public DslCiProcessor(List<CiProcessor> processors) {
        processors.forEach(processor -> processorMap.put(processor.getType(), processor));
    }

    @Override
    public void process(final DslProcessingContext processingContext, final ConfigurationItem ci) {
        List<Type> superTypes = new ArrayList<>();
        superTypes.add(ci.getType());
        superTypes.addAll(ci.getType().getDescriptor().getSuperClasses());

        Optional<CiProcessor> processor = superTypes.stream()
                .filter(processorMap::containsKey)
                .findFirst()
                .map(processorMap::get);

        processor.ifPresent(ciProcessor -> ciProcessor.process(processingContext, ci));
    }

    @Override
    public Type getType() {
        return Type.valueOf(ConfigurationItem.class);
    }

}
