/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

public class DslError
extends RuntimeException {
    public DslError(String msg) {
        super(msg);
    }

    public DslError(String format, Object ... params) {
        super(String.format(format, params));
    }

    static class UnableToFindFolderByPath
    extends DslError {
        public UnableToFindFolderByPath(String folderPath) {
            super("No folder found with path '%s'.", folderPath);
        }
    }

    static class UnableToFindFolderById
    extends DslError {
        public UnableToFindFolderById(String folderId) {
            super("No folder found with id '%s'.", folderId);
        }
    }

    static class UnableToFindTemplateTitleInPath
    extends DslError {
        UnableToFindTemplateTitleInPath(String path) {
            super("Unable to find template title in '%s'.", path);
        }
    }

    static class NoViewPermissionOnTemplateTitle
    extends DslError {
        NoViewPermissionOnTemplateTitle(String title) {
            super("You don't have view permissions on the template with title '%s'.", title);
        }
    }

    static class MoreThanOnTemplateWithTitle
    extends DslError {
        MoreThanOnTemplateWithTitle(String title) {
            super("More than on template found with title '%s'.", title);
        }
    }

    static class TemplateByTitleNotFound
    extends DslError {
        TemplateByTitleNotFound(String title) {
            super("No template found with title '%s'.", title);
        }
    }

    static class TemplateByIdNotFound
    extends DslError {
        TemplateByIdNotFound(String templateId) {
            super("No template found with id '%s'.", templateId);
        }
    }
}

