/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.DslApi;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.ReleasefileExporter;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DslApiImpl
implements DslApi {
    private PermissionChecker permissions;
    private ReleaseService releaseService;
    private ReleasefileExporter releasefileExporter;

    @Autowired
    public DslApiImpl(PermissionChecker permissions, ReleaseService releaseService, ReleasefileExporter releasefileExporter) {
        this.permissions = permissions;
        this.releaseService = releaseService;
        this.releasefileExporter = releasefileExporter;
    }

    public Response previewExportTemplateToXFile(String templateId, boolean asTemplate) {
        this.permissions.checkView(templateId);
        Preconditions.checkArgument((boolean)this.releaseService.isTemplate(templateId), (Object)"Only templates can be exported.");
        Release template = this.releaseService.findById(templateId);
        return Response.ok((Object)this.releasefileExporter.exportAsString(template, asTemplate)).build();
    }

    @Workdir(prefix="export")
    public Response exportTemplateToXFile(String templateId, boolean asTemplate) {
        this.permissions.checkView(templateId);
        Preconditions.checkArgument((boolean)this.releaseService.isTemplate(templateId), (Object)"Only templates can be exported.");
        Release template = this.releaseService.findById(templateId);
        WorkDir workDir = WorkDirContext.get();
        StreamingOutput output = outputStream -> {
            try {
                this.releasefileExporter.exportZippedWithAttachments(template, asTemplate, outputStream);
            }
            finally {
                workDir.delete();
            }
        };
        return ResponseHelper.streamFile((String)(template.getTitle() + ".zip"), (StreamingOutput)output, (String)"application/zip");
    }

    public String exportTemplate(Release template) {
        return this.exportTemplate(template, false);
    }

    public String exportTemplate(Release template, boolean asTemplate) {
        return this.apiExportTemplate(template, asTemplate);
    }

    private String apiExportTemplate(Release template, boolean renderAsTemplate) {
        Preconditions.checkArgument((boolean)this.releaseService.isTemplate(template.getId()), (Object)"Only templates can be exported.");
        this.permissions.checkView(template.getId());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.releasefileExporter.exportAsReleasefile(template, renderAsTemplate, baos);
        try {
            return baos.toString(StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

