/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.resolver;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryFilters;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissionChecker;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.dsl.resolver.DeliveryTaskPathResolver;
import com.xebialabs.xlrelease.dsl.resolver.DeliveryTaskPathResolver$;
import com.xebialabs.xlrelease.dsl.resolver.PathResolution;
import com.xebialabs.xlrelease.dsl.service.DslError;
import com.xebialabs.xlrelease.dsl.service.PathUtils;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.FolderService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\t\u0013\u0001uA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005U!A1\u0007\u0001BC\u0002\u0013\u0005A\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00036\u0011!a\u0004A!b\u0001\n\u0003i\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u000b\u0015\u0003A\u0011\u0001$\t\u000fi\u0003!\u0019!C\u00057\"1q\u000f\u0001Q\u0001\nqCQ\u0001\u001f\u0001\u0005BeDq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u0002J\u0001!I!a\u0013\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBA6\u0001\u0011%\u0011Q\u000e\u0005\b\u0003o\u0002A\u0011BA=\u0005q!U\r\\5wKJLH+Y:l\rJ|W\u000eU1uQJ+7o\u001c7wKJT!a\u0005\u000b\u0002\u0011I,7o\u001c7wKJT!!\u0006\f\u0002\u0007\u0011\u001cHN\u0003\u0002\u00181\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00033i\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003m\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011QEJ\u0007\u0002%%\u0011qE\u0005\u0002\u0019\t\u0016d\u0017N^3ssR\u000b7o\u001b)bi\"\u0014Vm]8mm\u0016\u0014\u0018A\u00053fY&4XM]=SKB|7/\u001b;pef,\u0012A\u000b\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\n!B]3q_NLGo\u001c:z\u0015\tyc#\u0001\u0005eK2Lg/\u001a:z\u0013\t\tDF\u0001\nEK2Lg/\u001a:z%\u0016\u0004xn]5u_JL\u0018a\u00053fY&4XM]=SKB|7/\u001b;pef\u0004\u0013!\u00044pY\u0012,'oU3sm&\u001cW-F\u00016!\t1\u0014(D\u00018\u0015\tAd#A\u0004tKJ4\u0018nY3\n\u0005i:$!\u0004$pY\u0012,'oU3sm&\u001cW-\u0001\bg_2$WM]*feZL7-\u001a\u0011\u0002#A,'/\\5tg&|gn\u00115fG.,'/F\u0001?!\ty$)D\u0001A\u0015\t\te&\u0001\u0005tK\u000e,(/\u001b;z\u0013\t\u0019\u0005IA\rEK2Lg/\u001a:z!\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\u0018A\u00059fe6L7o]5p]\u000eCWmY6fe\u0002\na\u0001P5oSRtD\u0003B$I\u0013*\u0003\"!\n\u0001\t\u000b!:\u0001\u0019\u0001\u0016\t\u000bM:\u0001\u0019A\u001b\t\u000bq:\u0001\u0019\u0001 )\u0005\u001da\u0005CA'Y\u001b\u0005q%BA(Q\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003#J\u000bqAZ1di>\u0014\u0018P\u0003\u0002T)\u0006)!-Z1og*\u0011QKV\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq+A\u0002pe\u001eL!!\u0017(\u0003\u0013\u0005+Ho\\<je\u0016$\u0017!\u00049bi\"\u0014Vm]8mm\u0016\u00148/F\u0001]!\riV\r\u001b\b\u0003=\u000et!a\u00182\u000e\u0003\u0001T!!\u0019\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013B\u00013!\u0003\u001d\u0001\u0018mY6bO\u0016L!AZ4\u0003\u0007M+\u0017O\u0003\u0002eAA!q$[6t\u0013\tQ\u0007E\u0001\u0004UkBdWM\r\t\u0003YBt!!\u001c8\u0011\u0005}\u0003\u0013BA8!\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=\u0004\u0003C\u0001;v\u001b\u0005\u0001\u0011B\u0001<'\u0005!\u0011Vm]8mm\u0016\u0014\u0018A\u00049bi\"\u0014Vm]8mm\u0016\u00148\u000fI\u0001\be\u0016\u001cx\u000e\u001c<f)\rQ\u0018\u0011\u0004\t\u0006Ynl\u00181C\u0005\u0003yJ\u00141!T1q!\rq\u0018qB\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u001d\u0011XM\u001a7fGRTA!!\u0002\u0002\b\u0005\u0019\u0011\r]5\u000b\t\u0005%\u00111B\u0001\u0007a2,x-\u001b8\u000b\u0007\u00055\u0001$\u0001\u0005eKBdw._5u\u0013\r\t\tb \u0002\u0013!J|\u0007/\u001a:us\u0012+7o\u0019:jaR|'\u000fE\u0002&\u0003+I1!a\u0006\u0013\u00059\u0001\u0016\r\u001e5SKN|G.\u001e;j_:Dq!a\u0007\u000b\u0001\u0004\ti\"\u0001\u0002dSB!\u0011qDA\u0013\u001b\t\t\tC\u0003\u0003\u0002$\u0005\r\u0011aA;e[&!\u0011qEA\u0011\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\\\u0001\u0015I\u0016d\u0017N^3ssB\u000bG\u000f\u001b*fg>dg/\u001a:\u0015\u0013-\fi#a\f\u00024\u0005]\u0002bBA\u000e\u0017\u0001\u0007\u0011Q\u0004\u0005\u0007\u0003cY\u0001\u0019A6\u0002\u0011A\u0014x\u000e]3sifDa!!\u000e\f\u0001\u0004Y\u0017!\u0002<bYV,\u0007bBA\u001d\u0017\u0001\u0007\u00111H\u0001\fe\u0016\u001cx\u000e\\;uS>t7\u000fE\u0004\u0002>\u0005\u001d3.a\u0005\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nq!\\;uC\ndWMC\u0002\u0002F\u0001\n!bY8mY\u0016\u001cG/[8o\u0013\ra\u0018qH\u0001\u0012gR\fw-\u001a)bi\"\u0014Vm]8mm\u0016\u0014H#C6\u0002N\u0005=\u0013\u0011KA*\u0011\u001d\tY\u0002\u0004a\u0001\u0003;Aa!!\r\r\u0001\u0004Y\u0007BBA\u001b\u0019\u0001\u00071\u000eC\u0004\u0002:1\u0001\r!a\u000f\u0002)%\u001ch*Z<WC2,X\rR3mSZ,'/_%e)\u0011\tI&a\u0018\u0011\u0007}\tY&C\u0002\u0002^\u0001\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002b5\u0001\r!a\u0005\u0002\r\rD\u0017M\\4f\u0003e\u0011Xm]8mm\u0016$U\r\\5wKJL\u0018\n\u001a$s_6\u0004\u0016\r\u001e5\u0015\u0007-\f9\u0007\u0003\u0004\u0002j9\u0001\ra[\u0001\rI\u0016d\u0017N^3ssB\u000bG\u000f[\u0001\u001be\u0016\u001cx\u000e\u001c<f'R\fw-Z%e\rJ|W.\u00133PeB\u000bG\u000f\u001b\u000b\u0006W\u0006=\u00141\u000f\u0005\u0007\u0003cz\u0001\u0019A6\u0002\u0015\u0011,G.\u001b<fefLE\r\u0003\u0004\u0002v=\u0001\ra[\u0001\tS\u0012|%\u000fU1uQ\u0006)2\r[3dW\u0012+G.\u001b<fefLE-\u0012=jgR\u001cHCBA>\u0003\u0003\u000b\u0019\tE\u0002 \u0003{J1!a !\u0005\u0011)f.\u001b;\t\r\u0005E\u0002\u00031\u0001l\u0011\u0019\t)\u0004\u0005a\u0001W\"\u001a\u0001!a\"\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$U\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003#\u000bYIA\u0005D_6\u0004xN\\3oi\u0002")
public class DeliveryTaskFromPathResolver
implements DeliveryTaskPathResolver {
    private final DeliveryRepository deliveryRepository;
    private final FolderService folderService;
    private final DeliveryPermissionChecker permissionChecker;
    private final Seq<Tuple2<String, Function4<ConfigurationItem, String, String, Map<String, PathResolution>, String>>> pathResolvers;

    @Override
    public scala.collection.immutable.Map<PropertyDescriptor, PathResolution> resolveCi(ConfigurationItem ci, Seq<Tuple2<String, Function4<ConfigurationItem, String, String, Map<String, PathResolution>, String>>> resolvers) {
        return DeliveryTaskPathResolver.resolveCi$(this, ci, resolvers);
    }

    @Override
    public Option<PathResolution> resolveProperty(ConfigurationItem ci, String property, Map<String, PathResolution> resolutions, Function4<ConfigurationItem, String, String, Map<String, PathResolution>, String> resolver) {
        return DeliveryTaskPathResolver.resolveProperty$(this, ci, property, resolutions, resolver);
    }

    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public FolderService folderService() {
        return this.folderService;
    }

    public DeliveryPermissionChecker permissionChecker() {
        return this.permissionChecker;
    }

    private Seq<Tuple2<String, Function4<ConfigurationItem, String, String, Map<String, PathResolution>, String>>> pathResolvers() {
        return this.pathResolvers;
    }

    @Override
    public scala.collection.immutable.Map<PropertyDescriptor, PathResolution> resolve(ConfigurationItem ci) {
        return this.resolveCi(ci, this.pathResolvers());
    }

    private String deliveryPathResolver(ConfigurationItem ci, String property, String value, Map<String, PathResolution> resolutions) {
        String resolvedId = Ids.isDeliveryId((String)value) ? value : this.resolveDeliveryIdFromPath(value);
        this.checkDeliveryIdExists(property, resolvedId);
        return resolvedId;
    }

    private String stagePathResolver(ConfigurationItem ci, String property, String value, Map<String, PathResolution> resolutions) {
        String string;
        if (Ids.isStageId((String)value)) {
            string = this.resolveStageIdFromIdOrPath(Ids.getParentId((String)value), value);
        } else {
            String deliveryId = (String)resolutions.get((Object)DeliveryTaskPathResolver$.MODULE$.deliveryIdField()).filter((Function1 & Serializable)change -> BoxesRunTime.boxToBoolean((boolean)this.isNewValueDeliveryId(change))).orElse((Function0 & Serializable)() -> resolutions.get((Object)DeliveryTaskPathResolver$.MODULE$.patternIdField())).filter((Function1 & Serializable)change -> BoxesRunTime.boxToBoolean((boolean)this.isNewValueDeliveryId(change))).map((Function1 & Serializable)x$1 -> (String)x$1.newValue().get()).getOrElse((Function0 & Serializable)() -> {
                throw new DslError(new StringBuilder(59).append("Missing either delivery or pattern to resolve stage name '").append(value).append("'").toString());
            });
            string = this.resolveStageIdFromIdOrPath(deliveryId, value);
        }
        return string;
    }

    private boolean isNewValueDeliveryId(PathResolution change) {
        return change.newValue().isSuccess() && change.newValue().get() != null && Ids.isDeliveryId((String)((String)change.newValue().get()));
    }

    private String resolveDeliveryIdFromPath(String deliveryPath) {
        String head;
        block7: {
            String deliveryTitle;
            block6: {
                List deliveryIds;
                String string;
                Option folderPath = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(PathUtils.folderPath(deliveryPath)));
                try {
                    string = (String)folderPath.map((Function1 & Serializable)path -> this.folderService().findByPath(path, 0).getId()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                }
                catch (NotFoundException notFoundException) {
                    throw new DslError(new StringBuilder(29).append("No folder found with path '").append(folderPath.getOrElse((Function0 & Serializable)() -> "")).append("'.").toString());
                }
                String folderId = string;
                deliveryTitle = (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(PathUtils.releasePath(deliveryPath))).getOrElse((Function0 & Serializable)() -> {
                    throw new DslError(new StringBuilder(36).append("Unable to find delivery title in '").append(deliveryPath).append("'.").toString());
                });
                List list = deliveryIds = this.deliveryRepository().searchIds(new DeliveryFilters().withStatuses(DeliveryStatus.values()).withTitle(deliveryTitle).withStrictTitleMatch(true).withFolderId(folderId)).toList();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    throw new DslError(new StringBuilder(43).append("No delivery or pattern found with title '").append(deliveryTitle).append("'.").toString());
                }
                if (!(list instanceof .colon.colon)) break block6;
                .colon.colon colon2 = (.colon.colon)list;
                head = (String)colon2.head();
                List list3 = colon2.next$access$1();
                Nil$ nil$2 = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) break block7;
            }
            throw new DslError(new StringBuilder(54).append("More then one delivery or pattern found with title '").append(deliveryTitle).append("'.").toString());
        }
        this.permissionChecker().checkView(head);
        String string = head;
        return string;
    }

    private String resolveStageIdFromIdOrPath(String deliveryId, String idOrPath) {
        String string;
        try {
            Delivery delivery = this.deliveryRepository().read(deliveryId);
            string = delivery.getStageByIdOrTitle(idOrPath).getId();
        }
        catch (NotFoundException notFoundException) {
            throw new DslError(new StringBuilder(35).append("No stage found with id or title '").append(idOrPath).append("'.").toString());
        }
        return string;
    }

    private void checkDeliveryIdExists(String property, String value) {
        try {
            Delivery delivery = this.deliveryRepository().read(value);
            String string = property;
            String string2 = DeliveryTaskPathResolver$.MODULE$.deliveryIdField();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                DeliveryStatus deliveryStatus = delivery.getStatus();
                DeliveryStatus deliveryStatus2 = DeliveryStatus.TEMPLATE;
                if (!(deliveryStatus != null ? !deliveryStatus.equals(deliveryStatus2) : deliveryStatus2 != null)) {
                    throw new DslError(new StringBuilder(61).append("The referenced id '").append(value).append("' is a pattern where delivery is expected.").toString());
                }
            }
            String string3 = property;
            String string4 = DeliveryTaskPathResolver$.MODULE$.patternIdField();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                DeliveryStatus deliveryStatus = delivery.getStatus();
                DeliveryStatus deliveryStatus3 = DeliveryStatus.TEMPLATE;
                if (deliveryStatus == null ? deliveryStatus3 != null : !deliveryStatus.equals(deliveryStatus3)) {
                    throw new DslError(new StringBuilder(61).append("The referenced id '").append(value).append("' is a delivery where pattern is expected.").toString());
                }
            }
        }
        catch (NotFoundException notFoundException) {
            throw new DslError(new StringBuilder(40).append("No delivery or pattern found with id '").append(value).append("'.").toString());
        }
    }

    @Autowired
    public DeliveryTaskFromPathResolver(DeliveryRepository deliveryRepository, FolderService folderService, DeliveryPermissionChecker permissionChecker) {
        this.deliveryRepository = deliveryRepository;
        this.folderService = folderService;
        this.permissionChecker = permissionChecker;
        DeliveryTaskPathResolver.$init$(this);
        this.pathResolvers = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DeliveryTaskPathResolver$.MODULE$.deliveryIdField(), (Function4 & Serializable)(ci, property, value, resolutions) -> this.deliveryPathResolver((ConfigurationItem)ci, (String)property, (String)value, (Map<String, PathResolution>)resolutions)), new Tuple2((Object)DeliveryTaskPathResolver$.MODULE$.patternIdField(), (Function4 & Serializable)(ci, property, value, resolutions) -> this.deliveryPathResolver((ConfigurationItem)ci, (String)property, (String)value, (Map<String, PathResolution>)resolutions)), new Tuple2((Object)DeliveryTaskPathResolver$.MODULE$.stageIdField(), (Function4 & Serializable)(ci, property, value, resolutions) -> this.stagePathResolver((ConfigurationItem)ci, (String)property, (String)value, (Map<String, PathResolution>)resolutions))}));
    }
}

