/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.FacetService;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Path(value="/fixtures/facets")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@NoCache
public class FixturesFacetResource {
    private static final Logger logger = LoggerFactory.getLogger(FixturesFacetResource.class);
    private FacetService facetService;
    private PermissionChecker permissions;

    public FixturesFacetResource(FacetService facetService, PermissionChecker permissions) {
        this.facetService = facetService;
        this.permissions = permissions;
    }

    @POST
    public void createFacet(Facet facet) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating facet: %s", facet.getName()));
        this.facetService.create(facet);
    }
}

