package com.xebialabs.xlrelease.api.internal;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.FacetService;

import static com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN;

@Path("/fixtures/facets")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
@NoCache
public class FixturesFacetResource {

    private static final Logger logger = LoggerFactory.getLogger(FixturesFacetResource.class);

    private FacetService facetService;
    private PermissionChecker permissions;

    public FixturesFacetResource(FacetService facetService, PermissionChecker permissions) {
        this.facetService = facetService;
        this.permissions = permissions;
    }

    @POST
    public void createFacet(Facet facet) {
        this.permissions.check(ADMIN);
        logger.debug(String.format("Creating facet: %s", facet.getName()));

        facetService.create(facet);
    }
}
