/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.security.PermissionChecker;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Path(value="/fixtures/riskProfiles")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@NoCache
public class FixturesRiskProfileResource {
    private static final Logger logger = LoggerFactory.getLogger(FixturesRiskProfileResource.class);
    private PermissionChecker permissions;
    private RiskProfileService riskProfileService;

    public FixturesRiskProfileResource(PermissionChecker permissions, RiskProfileService riskProfileService) {
        this.permissions = permissions;
        this.riskProfileService = riskProfileService;
    }

    @POST
    public void createRiskProfile(RiskProfile riskProfile) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating risk profile: %s", riskProfile.getName()));
        this.riskProfileService.create(riskProfile);
    }

    @Path(value="/{riskProfileId:.*}")
    @DELETE
    public void deleteRiskProfile(@PathParam(value="riskProfileId") String riskProfileId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting risk profile: %s", riskProfileId));
        if (this.riskProfileService.exists(riskProfileId)) {
            this.riskProfileService.delete(riskProfileId);
        }
    }
}

