package com.xebialabs.xlrelease.api.internal;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;

import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobFilters;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;

import static com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN;

@Path("/fixtures/reports")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
@NoCache
public class FixturesReportsResource {

    private static final Logger logger = LoggerFactory.getLogger(FixturesReportsResource.class);

    private ReportJobRepository reportJobRepository;
    private PermissionChecker permissions;

    public FixturesReportsResource(ReportJobRepository reportJobRepository, PermissionChecker permissions) {
        this.reportJobRepository = reportJobRepository;
        this.permissions = permissions;
    }

    @POST
    public ReportJob createReportJob(ReportJob reportJob) {
        this.permissions.check(ADMIN);
        logger.debug("Creating report job: {}", reportJob.getReportName());
        ReportJob createdJob = reportJobRepository.create(reportJob);
        return createdJob;
    }

    @DELETE
    @Path("/{reportJobId}")
    public void deleteReportJob(@PathParam("reportJobId") Integer reportJobId) {
        this.permissions.check(ADMIN);
        logger.debug("Deleting report job: {}", reportJobId);
        reportJobRepository.delete(reportJobId);
    }

    @POST
    @Path("/delete/all")
    public void deleteReportJobs() {
        this.permissions.check(ADMIN);
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        Page<ReportJob> result = reportJobRepository.query(reportJobFilters, PageRequest.of(0, Integer.MAX_VALUE));
        result.forEach(
                reportJob -> {
                    try {
                        this.deleteReportJob(reportJob.getJobId());
                    } catch (Exception e) {
                        logger.warn(e.getMessage());
                    }
                });
    }

}
