package com.xebialabs.xlrelease.api.internal;

import java.util.Arrays;
import java.util.HashSet;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.runner.RemoteJobRunner;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.runner.domain.RunnerToken;
import com.xebialabs.xlrelease.runner.service.RunnerTokenService;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ConfigurationService;

import static com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN;

@Path("/fixtures/runners")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
@NoCache
public class FixturesRunnerResource {

    private PermissionChecker permissions;
    private CiIdService ciIdService;
    private ConfigurationService configurationService;

    private RunnerTokenService runnerTokenService;


    public FixturesRunnerResource(PermissionChecker permissions, CiIdService ciIdService, ConfigurationService configurationService, RunnerTokenService runnerTokenService) {
        this.permissions = permissions;
        this.ciIdService = ciIdService;
        this.configurationService = configurationService;
        this.runnerTokenService = runnerTokenService;
    }

    @POST
    @Path("register")
    public RunnerToken registerRunner() {
        this.permissions.check(ADMIN);
        String id = ciIdService.getUniqueId(Type.valueOf(Configuration.class), Ids.CUSTOM_CONFIGURATION_ROOT);
        RemoteJobRunner newRunner = Type.valueOf(RemoteJobRunner.class).getDescriptor().newInstance(id);
        newRunner.setTitle("Runner - xyz");
        newRunner.setCapabilities(new HashSet<>(Arrays.asList("remote", "container")));
        newRunner.setPublicKey("Dummy public key");
        newRunner.setVersion("development");
        newRunner.setRunnerName("dev-remote-runner");
        configurationService.createOrUpdate(newRunner);
        return runnerTokenService.createOrUpdateRunnerToken(id);
    }

    @DELETE
    @Path("{id:Configuration.*}")
    public void deleteRunner(@PathParam("id") String id) {
        this.permissions.check(ADMIN);
        configurationService.delete(id);
        runnerTokenService.deleteRunnerToken(id);
    }
}
