package com.xebialabs.xlrelease.api.internal;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.security.PermissionChecker;

import static com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN;

@Path("/fixtures/riskProfiles")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
@NoCache
public class FixturesRiskProfileResource {

    private static final Logger logger = LoggerFactory.getLogger(FixturesRiskProfileResource.class);

    private PermissionChecker permissions;
    private RiskProfileService riskProfileService;

    public FixturesRiskProfileResource(PermissionChecker permissions, RiskProfileService riskProfileService) {
        this.permissions = permissions;
        this.riskProfileService = riskProfileService;
    }

    @POST
    public void createRiskProfile(RiskProfile riskProfile) {
        this.permissions.check(ADMIN);
        logger.debug(String.format("Creating risk profile: %s", riskProfile.getName()));

        riskProfileService.create(riskProfile);
    }

    @Path("/{riskProfileId:.*}")
    @DELETE
    public void deleteRiskProfile(@PathParam("riskProfileId") String riskProfileId) {
        this.permissions.check(ADMIN);
        logger.debug(String.format("Deleting risk profile: %s", riskProfileId));

        if (riskProfileService.exists(riskProfileId)) {
            riskProfileService.delete(riskProfileId);
        }
    }
}
