/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobFilters;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;

@Path(value="/fixtures/reports")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@NoCache
public class FixturesReportsResource {
    private static final Logger logger = LoggerFactory.getLogger(FixturesReportsResource.class);
    private ReportJobRepository reportJobRepository;
    private PermissionChecker permissions;

    public FixturesReportsResource(ReportJobRepository reportJobRepository, PermissionChecker permissions) {
        this.reportJobRepository = reportJobRepository;
        this.permissions = permissions;
    }

    @POST
    public ReportJob createReportJob(ReportJob reportJob) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("Creating report job: {}", (Object)reportJob.getReportName());
        ReportJob createdJob = this.reportJobRepository.create(reportJob);
        return createdJob;
    }

    @DELETE
    @Path(value="/{reportJobId}")
    public void deleteReportJob(@PathParam(value="reportJobId") Integer reportJobId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("Deleting report job: {}", (Object)reportJobId);
        this.reportJobRepository.delete(reportJobId);
    }

    @POST
    @Path(value="/delete/all")
    public void deleteReportJobs() {
        this.permissions.check(PlatformPermissions.ADMIN);
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        Page result = this.reportJobRepository.query(reportJobFilters, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        result.forEach(reportJob -> {
            try {
                this.deleteReportJob(reportJob.getJobId());
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        });
    }
}

