/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.external;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.ExternalScriptTask;
import com.xebialabs.xlrelease.domain.ScriptEngine;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.VariableOrPasswordView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ExternalScriptTaskViewConverter
extends BaseTaskViewConverter<ExternalScriptTask> {
    protected Class<ExternalScriptTask> getTaskClass() {
        return ExternalScriptTask.class;
    }

    public TaskFullView toFullView(ExternalScriptTask task, List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView customTaskView = super.toFullView((Task)task, allowedTaskTypesForAuthenticatedUser);
        customTaskView.setServer(task.getUrl());
        customTaskView.setUsername(task.getUsername());
        customTaskView.setPassword(new VariableOrPasswordView(task.getPassword()));
        customTaskView.setScript(task.getScriptEngine().name());
        return customTaskView;
    }

    protected ExternalScriptTask fromView(TaskFullView view) {
        ExternalScriptTask task = new ExternalScriptTask();
        task.setUrl(view.getServer());
        task.setUsername(view.getUsername());
        task.setPassword(view.getPassword().variableOrValue());
        task.setScriptEngine(ScriptEngine.valueOf(view.getScript()));
        return task;
    }
}

