package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.ExternalScriptTask
import groovy.transform.TypeChecked

/**
 * DSL for ExternalScriptTask
 */
@TypeChecked
class ExternalScriptTaskSpec extends TaskSpec<ExternalScriptTask> {

  ExternalScriptTaskSpec(String title = null) {
    super(title, Type.valueOf(ExternalScriptTask))
  }

  /**
   * Specify the URL for the script.
   * The url should produce a file with either 'python' or 'groovy' as extension
   * @param url
   */
  void url(String url) {
    configurationItem.url = url
  }

  /**
   * Specify a username to access the file if applicable
   * @param username
   */
  void username(String username) {
    configurationItem.username = username
  }

  /**
   * Specify a password to access the file if applicable
   * @param password
   */
  void password(String password) {
    configurationItem.password = password
  }
}