package com.xebialabs.xlrelease.domain.tasks.external;

import java.util.List;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.ExternalScriptTask;
import com.xebialabs.xlrelease.domain.ScriptEngine;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.VariableOrPasswordView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;

@Component
public class ExternalScriptTaskViewConverter extends BaseTaskViewConverter<ExternalScriptTask> {

    @Override
    protected Class<ExternalScriptTask> getTaskClass() {
        return ExternalScriptTask.class;
    }

    @Override
    public TaskFullView toFullView(final ExternalScriptTask task, final List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView customTaskView = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);

        customTaskView.setServer(task.getUrl());
        customTaskView.setUsername(task.getUsername());
        customTaskView.setPassword(new VariableOrPasswordView(task.getPassword()));
        customTaskView.setScript(task.getScriptEngine().name());
        customTaskView.setIgnoreScriptVariableInterpolation(task.isScriptInterpolationOff());

        return customTaskView;
    }

    @Override
    protected ExternalScriptTask fromView(final TaskFullView view) {
        ExternalScriptTask task = new ExternalScriptTask();

        task.setUrl(view.getServer());
        task.setUsername(view.getUsername());
        task.setPassword(view.getPassword().variableOrValue());
        task.setScriptEngine(view.getScript() != null ? ScriptEngine.valueOf(view.getScript()) : ScriptEngine.AUTODETECT);
        task.setIgnoreScriptVariableInterpolation(view.isIgnoreScriptVariableInterpolation());

        return task;
    }
}
