package com.xebialabs.xlrelease.domain.tasks.external;

import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.ExternalScriptTask;
import com.xebialabs.xlrelease.domain.tasks.BaseScriptTaskExecutor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.scheduler.ScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.WorkManager;
import com.xebialabs.xlrelease.script.TaskSoftReference;

@Component
public class ExternalScriptTaskExecutor extends BaseScriptTaskExecutor<ExternalScriptTask> {

    protected ExternalScriptTaskExecutor(WorkManager workManager, TaskRepository taskRepository) {
        super(workManager, taskRepository);
    }

    @Override
    public Class<? extends ExternalScriptTask> getTaskClass() {
        return ExternalScriptTask.class;
    }

    @Override
    public void execute(TaskSoftReference<ExternalScriptTask> taskRef) {
        workManager.submit(new ScriptTaskJob(taskRef));
    }
}
