/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentReservationForm;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentReservationView;
import com.xebialabs.xlrelease.api.v1.views.search.EnvironmentReservationSearchView;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import com.xebialabs.xlrelease.environments.service.EnvironmentReservationSecurity;
import com.xebialabs.xlrelease.environments.service.EnvironmentReservationService;
import com.xebialabs.xlrelease.rest.AllCILevels;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/environments/reservations")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class EnvironmentReservationApi
implements ApiService {
    private EnvironmentReservationService environmentReservationService;
    private EnvironmentReservationSecurity environmentReservationSecurity;
    private ApplicationService applicationService;

    public String serviceName() {
        return "environmentReservationApi";
    }

    @Autowired
    public EnvironmentReservationApi(EnvironmentReservationService environmentReservationService, EnvironmentReservationSecurity environmentReservationSecurity, ApplicationService applicationService) {
        this.environmentReservationService = environmentReservationService;
        this.environmentReservationSecurity = environmentReservationSecurity;
        this.applicationService = applicationService;
    }

    @POST
    @Timed
    public EnvironmentReservationView createReservation(EnvironmentReservationForm environmentReservationForm) {
        this.environmentReservationSecurity.checkCreate();
        EnvironmentReservation reservation = environmentReservationForm.toEnvironmentReservation();
        return EnvironmentReservationView.fromEnvironmentReservation(this.environmentReservationService.createReservation(reservation));
    }

    @GET
    @Timed
    @Path(value="/{environmentReservationId:.*/EnvironmentReservation[^/]*}")
    public EnvironmentReservationView getReservation(@PathParam(value="environmentReservationId") String environmentReservationId) {
        this.environmentReservationSecurity.checkView();
        return EnvironmentReservationView.fromEnvironmentReservation(this.environmentReservationService.findReservationById(environmentReservationId));
    }

    @PUT
    @Timed
    @Path(value="/{environmentReservationId:.*/EnvironmentReservation[^/]*}")
    public EnvironmentReservationView updateReservation(@PathParam(value="environmentReservationId") String environmentReservationId, EnvironmentReservationForm environmentReservationForm) {
        this.environmentReservationSecurity.checkEdit();
        EnvironmentReservation reservation = environmentReservationForm.toEnvironmentReservation();
        reservation.setId(environmentReservationId);
        return EnvironmentReservationView.fromEnvironmentReservation(this.environmentReservationService.updateReservation(reservation));
    }

    @POST
    @Timed
    @Path(value="/search")
    public List<EnvironmentReservationSearchView> searchReservations(ReservationFilters filters) {
        this.environmentReservationSecurity.checkView();
        filters.validate();
        return this.environmentReservationService.searchReservations(filters).entrySet().stream().map(e -> EnvironmentReservationSearchView.from((Environment)((Object)((Object)e.getKey())), (List)e.getValue())).collect(Collectors.toList());
    }

    @DELETE
    @PublicApiMember
    @Timed
    @Path(value="/{environmentReservationId:.*/EnvironmentReservation[^/]*}")
    public void delete(@PathParam(value="environmentReservationId") String environmentReservationId) {
        this.environmentReservationSecurity.checkEdit();
        this.environmentReservationService.deleteReservation(environmentReservationId);
    }

    @POST
    @PublicApiMember
    @Timed
    @Path(value="/{environmentReservationId:.*/EnvironmentReservation[^/]*}")
    public void addApplication(@PathParam(value="environmentReservationId") String environmentReservationId, @QueryParam(value="applicationId") String applicationId) {
        this.environmentReservationSecurity.checkEdit();
        EnvironmentReservation environmentReservation = this.environmentReservationService.findReservationById(environmentReservationId);
        Application application = this.applicationService.findApplicationById(applicationId);
        environmentReservation.addApplication(application);
        this.environmentReservationService.updateReservation(environmentReservation);
    }

    @PublicApiMember
    @Timed
    public EnvironmentReservation create(EnvironmentReservation environmentReservation) {
        this.environmentReservationSecurity.checkCreate();
        return this.environmentReservationService.createReservation(environmentReservation);
    }

    @PublicApiMember
    @Timed
    public EnvironmentReservation getById(String environmentReservationId) {
        this.environmentReservationSecurity.checkView();
        return this.environmentReservationService.findReservationById(environmentReservationId);
    }

    @PublicApiMember
    @Timed
    public EnvironmentReservation update(EnvironmentReservation environmentReservation) {
        this.environmentReservationSecurity.checkEdit();
        return this.environmentReservationService.updateReservation(environmentReservation);
    }

    @PublicApiMember
    @Timed
    public Map<String, List<EnvironmentReservation>> search(ReservationFilters filters) {
        this.environmentReservationSecurity.checkView();
        return this.environmentReservationService.searchReservations(filters).entrySet().stream().collect(Collectors.toMap(entry -> ((Environment)((Object)((Object)entry.getKey()))).getId(), Map.Entry::getValue));
    }

    @PublicApiMember
    @Timed
    public boolean hasReservation(String environmentId, String applicationId) {
        this.environmentReservationSecurity.checkView();
        return this.environmentReservationService.existsReservation(environmentId, applicationId);
    }

    public Date nearestComingReservation(String environmentId, String applicationId) {
        this.environmentReservationSecurity.checkView();
        return this.environmentReservationService.nearestComingReservation(environmentId, applicationId);
    }
}

