/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentLabelPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentStagePersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.Mappers$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.EnvironmentSqlBuilder$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENVIRONMENTS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENV_TO_LABEL$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.SecurablePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.package;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u0013'\u0001UB\u0001b\u0011\u0001\u0003\u0006\u0004%\u0019\u0001\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005\u000b\"A!\u000b\u0001BC\u0002\u0013\r1\u000b\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003U\u0011!a\u0007A!b\u0001\n\u0007i\u0007\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011U\u0004!Q1A\u0005\u0002YD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\tw\u0002\u0011)\u0019!C\u0001y\"I\u00111\u0001\u0001\u0003\u0002\u0003\u0006I! \u0005\u000b\u0003\u000b\u0001!Q1A\u0005\u0002\u0005\u001d\u0001BCA\b\u0001\t\u0005\t\u0015!\u0003\u0002\n!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001\"CA(\u0001\t\u0007I\u0011BA)\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005M\u0003\"CA3\u0001\t\u0007I\u0011BA)\u0011!\t9\u0007\u0001Q\u0001\n\u0005M\u0003bBA5\u0001\u0011\u0005\u00111\u000e\u0005\n\u00033\u0003!\u0019!C\u0005\u0003#B\u0001\"a'\u0001A\u0003%\u00111\u000b\u0005\n\u0003;\u0003!\u0019!C\u0005\u0003#B\u0001\"a(\u0001A\u0003%\u00111\u000b\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!a5\u0001\t\u0003\t)\u000eC\u0004\u0002b\u0002!\t!a9\t\u000f\u0005%\b\u0001\"\u0001\u0002l\"9\u0011Q \u0001\u0005\u0002\u0005}\b\"\u0003B\u0003\u0001\t\u0007I\u0011BA)\u0011!\u00119\u0001\u0001Q\u0001\n\u0005M\u0003b\u0002B\u0005\u0001\u0011\u0005!1\u0002\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u00119\u0003\u0001C\u0005\u0005SAqA!\u0011\u0001\t\u0013\u0011\u0019\u0005C\u0004\u0003J\u0001!\tAa\u0013\t\u000f\t]\u0003\u0001\"\u0003\u0003Z\t1RI\u001c<je>tW.\u001a8u!\u0016\u00148/[:uK:\u001cWM\u0003\u0002(Q\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\tI#&A\u0002tc2T!a\u000b\u0017\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002.]\u0005aQM\u001c<je>tW.\u001a8ug*\u0011q\u0006M\u0001\nq2\u0014X\r\\3bg\u0016T!!\r\u001a\u0002\u0013a,'-[1mC\n\u001c(\"A\u001a\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00011D\b\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004B]f\u0014VM\u001a\t\u0003{\u0005k\u0011A\u0010\u0006\u0003O}R!!\u000b!\u000b\u0005-r\u0013B\u0001\"?\u0005I\u0001VM]:jgR,gnY3TkB\u0004xN\u001d;\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003\u0015\u0003\"AR(\u000e\u0003\u001dS!\u0001S%\u0002\t\r|'/\u001a\u0006\u0003\u0015.\u000bAA\u001b3cG*\u0011A*T\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta*A\u0002pe\u001eL!\u0001U$\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0003\u001d!\u0017.\u00197fGR,\u0012\u0001\u0016\t\u0003+\"t!AV3\u000f\u0005]\u001bgB\u0001-b\u001d\tI\u0006M\u0004\u0002[?:\u00111LX\u0007\u00029*\u0011Q\fN\u0001\u0007yI|w\u000e\u001e \n\u0003MJ!!\r\u001a\n\u0005=\u0002\u0014B\u00012/\u0003\t!'-\u0003\u0002*I*\u0011!ML\u0005\u0003M\u001e\f!bU9m\u0005VLG\u000eZ3s\u0015\tIC-\u0003\u0002jU\n9A)[1mK\u000e$(B\u00014h\u0003!!\u0017.\u00197fGR\u0004\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c:\nqa]3sm&\u001cW-\u0003\u0002ta\nY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003Q\u0019XmY;sC\ndW\rU3sg&\u001cH/\u001a8dKV\tq\u000f\u0005\u0002>q&\u0011\u0011P\u0010\u0002\u0015'\u0016\u001cWO]1cY\u0016\u0004VM]:jgR,gnY3\u0002+M,7-\u001e:bE2,\u0007+\u001a:tSN$XM\\2fA\u0005YRM\u001c<je>tW.\u001a8u'R\fw-\u001a)feNL7\u000f^3oG\u0016,\u0012! \t\u0003}~l\u0011AJ\u0005\u0004\u0003\u00031#aG#om&\u0014xN\\7f]R\u001cF/Y4f!\u0016\u00148/[:uK:\u001cW-\u0001\u000ff]ZL'o\u001c8nK:$8\u000b^1hKB+'o]5ti\u0016t7-\u001a\u0011\u00027\u0015tg/\u001b:p]6,g\u000e\u001e'bE\u0016d\u0007+\u001a:tSN$XM\\2f+\t\tI\u0001E\u0002\u007f\u0003\u0017I1!!\u0004'\u0005m)eN^5s_:lWM\u001c;MC\n,G\u000eU3sg&\u001cH/\u001a8dK\u0006aRM\u001c<je>tW.\u001a8u\u0019\u0006\u0014W\r\u001c)feNL7\u000f^3oG\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0002\u0016Qq\u0011qCA\r\u0003o\ty$!\u0011\u0002D\u0005\u0015\u0003C\u0001@\u0001\u0011\u0015\u0019U\u0002q\u0001FQ!\tI\"!\b\u00022\u0005M\u0002\u0003BA\u0010\u0003[i!!!\t\u000b\t\u0005\r\u0012QE\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u0014\u0003S\tqAZ1di>\u0014\u0018PC\u0002\u0002,-\u000bQAY3b]NLA!a\f\u0002\"\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003k\t\u0011\u0004\u001f7s%\u0016\u0004xn]5u_JL(\n\u001a2d)\u0016l\u0007\u000f\\1uK\")!+\u0004a\u0002)\"B\u0011qGA\u000f\u0003c\tY$\t\u0002\u0002>\u00059\u0002\u0010\u001c:SKB|7/\u001b;pef\u001c\u0016\u000f\u001c#jC2,7\r\u001e\u0005\u0006Y6\u0001\u001dA\u001c\u0005\u0006k6\u0001\ra\u001e\u0005\u0006w6\u0001\r! \u0005\b\u0003\u000bi\u0001\u0019AA\u0005Q\ri\u0011\u0011\n\t\u0005\u0003?\tY%\u0003\u0003\u0002N\u0005\u0005\"!C!vi><\u0018N]3e\u0003a\u0019F+\u0014+`\u0013:\u001bVI\u0015+`\u000b:3\u0016JU(O\u001b\u0016sEkU\u000b\u0003\u0003'\u0002B!!\u0016\u0002^9!\u0011qKA-!\tY\u0006(C\u0002\u0002\\a\na\u0001\u0015:fI\u00164\u0017\u0002BA0\u0003C\u0012aa\u0015;sS:<'bAA.q\u0005I2\u000bV'U?&s5+\u0012*U?\u0016se+\u0013*P\u001d6+e\nV*!\u0003Q\u0019F+\u0014+`\u000bbK5\u000bV*`\u0005f{F+\u0013+M\u000b\u0006)2\u000bV'U?\u0016C\u0016j\u0015+T?\nKv\fV%U\u0019\u0016\u0003\u0013AB5og\u0016\u0014H\u000f\u0006\u0003\u0002n\u0005\u001d\u0005\u0003BA8\u0003\u0003sA!!\u001d\u0002~9!\u00111OA>\u001d\u0011\t)(!\u001f\u000f\u0007a\u000b9(\u0003\u0002,]%\u0011\u0011\u0006Q\u0005\u0003O}J1!a ?\u0003\u0011\u0019\u0015.\u00133\n\t\u0005\r\u0015Q\u0011\u0002\u0005\u0007&LEMC\u0002\u0002\u0000yBq!!#\u0013\u0001\u0004\tY)A\u0006f]ZL'o\u001c8nK:$\b\u0003BAG\u0003+k!!a$\u000b\u00075\n\tJC\u0002\u0002\u0014:\na\u0001Z8nC&t\u0017\u0002BAL\u0003\u001f\u00131\"\u00128wSJ|g.\\3oi\u0006A2\u000bV'U?V\u0003F)\u0011+F?\u0016se+\u0013*P\u001d6+e\nV*\u00023M#V\nV0V!\u0012\u000bE+R0F\u001dZK%k\u0014(N\u000b:#6\u000bI\u0001#'RkEkX#Y\u0013N#6kX!O\u001fRCUIU0F\u001dZ{v+\u0013+I?RKE\u000bT#\u0002GM#V\nV0F1&\u001bFkU0B\u001d>#\u0006*\u0012*`\u000b:3vlV%U\u0011~#\u0016\n\u0016'FA\u00051Q\u000f\u001d3bi\u0016$B!!*\u0002,B\u0019q'a*\n\u0007\u0005%\u0006HA\u0004C_>dW-\u00198\t\u000f\u0005%u\u00031\u0001\u0002\f\u0006qa-\u001b8e\u0013\u0012\u001c()_)vKJLH\u0003BAY\u0003\u0007\u0004b!a-\u0002>\u00065d\u0002BA[\u0003ss1aWA\\\u0013\u0005I\u0014bAA^q\u00059\u0001/Y2lC\u001e,\u0017\u0002BA`\u0003\u0003\u00141aU3r\u0015\r\tY\f\u000f\u0005\b\u0003\u000bD\u0002\u0019AAd\u0003E\u0019\u0018\u000f\\,ji\"\u0004\u0016M]1nKR,'o\u001d\t\u0005\u0003\u0013\fiMD\u0002W\u0003\u0017L1!a/h\u0013\u0011\ty-!5\u0003#M\u000bHnV5uQB\u000b'/Y7fi\u0016\u00148OC\u0002\u0002<\u001e\f\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0005\u0003/\fi\u000eE\u00038\u00033\fY)C\u0002\u0002\\b\u0012aa\u00149uS>t\u0007bBAp3\u0001\u0007\u0011QN\u0001\u000eK:4\u0018N]8o[\u0016tG/\u00133\u0002\u0017\u0019Lg\u000e\u001a\"z)&$H.\u001a\u000b\u0005\u0003/\f)\u000fC\u0004\u0002hj\u0001\r!!\u001c\u0002!\u0015tg/\u001b:p]6,g\u000e\u001e+ji2,\u0017a\u00034j]\u0012,\u0016\u000e\u001a\"z\u0013\u0012$B!!<\u0002|B)q'!7\u0002pB!\u0011\u0011_A{\u001d\u0011\t\t(a=\n\u0007\u0005mf(\u0003\u0003\u0002x\u0006e(!B\"j+&$'bAA^}!9\u0011q\\\u000eA\u0002\u00055\u0014AB:fCJ\u001c\u0007\u000e\u0006\u0003\u0003\u0002\t\r\u0001CBAZ\u0003{\u000bY\tC\u0004\u0002Fr\u0001\r!a2\u0002=M#V\nV0E\u000b2+E+R0F\u001dZK%k\u0014(N\u000b:#6k\u0018\"Z?&#\u0015aH*U\u001bR{F)\u0012'F)\u0016{VI\u0014,J%>sU*\u0012(U'~\u0013\u0015lX%EA\u00051A-\u001a7fi\u0016$BA!\u0004\u0003\u001aA1!q\u0002B\u000b\u0003Kk!A!\u0005\u000b\u0007\tM\u0001(\u0001\u0003vi&d\u0017\u0002\u0002B\f\u0005#\u00111\u0001\u0016:z\u0011\u001d\tyn\ba\u0001\u0003[\nAbZ3u\u0019\u0006\u0014W\r\\+jIN$BAa\b\u0003&AA\u0011Q\u000bB\u0011\u0003[\ny/\u0003\u0003\u0003$\u0005\u0005$aA'ba\"9\u0011\u0011\u0012\u0011A\u0002\u0005-\u0015AG5og\u0016\u0014H/\u00128w)>d\u0015MY3m%\u00164WM]3oG\u0016\u001cHC\u0002B\u0016\u0005g\u00119\u0004\u0005\u0004\u00024\u0006u&Q\u0006\t\u0004o\t=\u0012b\u0001B\u0019q\t\u0019\u0011J\u001c;\t\u000f\tU\u0012\u00051\u0001\u0002p\u0006qQM\u001c<je>tW.\u001a8u+&$\u0007b\u0002B\u001dC\u0001\u0007!1H\u0001\nY\u0006\u0014W\r\\+jIN\u0004b!!\u0016\u0003>\u0005=\u0018\u0002\u0002B \u0003C\u00121aU3u\u0003i)\b\u000fZ1uK\u0016sg\u000fV8MC\n,GNU3gKJ,gnY3t)\u0019\u0011YC!\u0012\u0003H!9\u0011\u0011\u0012\u0012A\u0002\u0005-\u0005b\u0002B\u001bE\u0001\u0007\u0011q^\u0001\rO\u0016$X+\u001b3t\u0005fLEm\u001d\u000b\u0005\u0005?\u0011i\u0005C\u0004\u0003P\r\u0002\rA!\u0015\u0002\u001d\u0015tg/\u001b:p]6,g\u000e^%egB1\u00111\u0017B*\u0003[JAA!\u0016\u0002B\nA\u0011\n^3sC\ndW-\u0001\rtC:LG/\u001b>f\u000b:4\u0018N]8o[\u0016tG/\u00138qkR$BAa\u0017\u0003bA\u0019qG!\u0018\n\u0007\t}\u0003H\u0001\u0003V]&$\bbBAEI\u0001\u0007\u00111\u0012\u0015\u0004\u0001\t\u0015\u0004\u0003\u0002B4\u0005[j!A!\u001b\u000b\u0007\t-t-A\u0006ue\u0006t7/Y2uS>t\u0017\u0002\u0002B8\u0005S\u0012q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c\u0015\u0004\u0001\tM\u0004\u0003\u0002B;\u0005wj!Aa\u001e\u000b\u0007\te4*\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA! \u0003x\tQ!+\u001a9pg&$xN]=")
public class EnvironmentPersistence
implements PersistenceSupport {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final CiIdService ciIdService;
    private final SecurablePersistence securablePersistence;
    private final EnvironmentStagePersistence environmentStagePersistence;
    private final EnvironmentLabelPersistence environmentLabelPersistence;
    private final String STMT_INSERT_ENVIRONMENTS;
    private final String STMT_EXISTS_BY_TITLE;
    private final String STMT_UPDATE_ENVIRONMENTS;
    private final String STMT_EXISTS_ANOTHER_ENV_WITH_TITLE;
    private final String STMT_DELETE_ENVIRONMENTS_BY_ID;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$((PersistenceSupport)this, params);
    }

    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$((PersistenceSupport)this, pairs);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        EnvironmentPersistence environmentPersistence = this;
        synchronized (environmentPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        return !this.bitmap$0 ? this.namedTemplate$lzycompute() : this.namedTemplate;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public SecurablePersistence securablePersistence() {
        return this.securablePersistence;
    }

    public EnvironmentStagePersistence environmentStagePersistence() {
        return this.environmentStagePersistence;
    }

    public EnvironmentLabelPersistence environmentLabelPersistence() {
        return this.environmentLabelPersistence;
    }

    private String STMT_INSERT_ENVIRONMENTS() {
        return this.STMT_INSERT_ENVIRONMENTS;
    }

    private String STMT_EXISTS_BY_TITLE() {
        return this.STMT_EXISTS_BY_TITLE;
    }

    public String insert(Environment environment) {
        this.sanitizeEnvironmentInput(environment);
        Integer stageUid = (Integer)this.environmentStagePersistence().findUidById(environment.getStage().getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(30).append("Environment stage [").append(environment.getStage().getId()).append("] not found").toString(), new Object[0]);
        });
        boolean exists = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_BY_TITLE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle())})), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EnvironmentPersistence.$anonfun$insert$2(x$1))).head());
        if (exists) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Environment with title '").append(environment.getTitle()).append("' already exists").toString());
        }
        Map<String, Integer> labelIdsToUids = this.getLabelUids(environment);
        Integer ciUid = this.securablePersistence().insert();
        String envId = package$.MODULE$.createPersistedId(ClassTag$.MODULE$.apply(Environment.class), this.ciIdService());
        String displayedEnvId = package$.MODULE$.toDisplayId(envId);
        try {
            this.sqlExec(this.STMT_INSERT_ENVIRONMENTS(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()), (Object)ciUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()), (Object)envId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION()), (Object)environment.getDescription()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID()), (Object)stageUid)})), x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute()));
        }
        catch (DuplicateKeyException ex) {
            throw new IllegalArgumentException(new StringBuilder(37).append("Environment with ID '").append(displayedEnvId).append("' already exists").toString(), ex);
        }
        this.insertEnvToLabelReferences(ciUid, (Set<Integer>)labelIdsToUids.valuesIterator().toSet());
        return displayedEnvId;
    }

    private String STMT_UPDATE_ENVIRONMENTS() {
        return this.STMT_UPDATE_ENVIRONMENTS;
    }

    private String STMT_EXISTS_ANOTHER_ENV_WITH_TITLE() {
        return this.STMT_EXISTS_ANOTHER_ENV_WITH_TITLE;
    }

    public boolean update(Environment environment) {
        Integer environmentUid = (Integer)this.findUidById(environment.getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(24).append("Environment [").append(environment.getId()).append("] not found").toString(), new Object[0]);
        });
        Integer stageUid = (Integer)this.environmentStagePersistence().findUidById(environment.getStage().getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(30).append("Environment stage [").append(environment.getStage().getId()).append("] not found").toString(), new Object[0]);
        });
        this.sanitizeEnvironmentInput(environment);
        boolean existsAnotherWithSameTitle = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_ANOTHER_ENV_WITH_TITLE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()), (Object)environmentUid)})), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)EnvironmentPersistence.$anonfun$update$3(x$3))).head());
        if (existsAnotherWithSameTitle) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Environment with title '").append(environment.getTitle()).append("' already exists").toString());
        }
        this.updateEnvToLabelReferences(environment, environmentUid);
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(this.STMT_UPDATE_ENVIRONMENTS(), this.paramMap2MapSqlParameterSource((Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION()), (Object)environment.getDescription()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()), (Object)environmentUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID()), (Object)stageUid)}))), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 == 1));
    }

    public Seq<String> findIdsByQuery(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().queryForList(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), String.class)).asScala();
    }

    public Option<Environment> findById(String environmentId) {
        Tuple2<String, Seq<Object>> tuple2 = EnvironmentSqlBuilder$.MODULE$.apply(EnvironmentSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).select().withEnvironmentId(package$.MODULE$.toPersistedId(environmentId)).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.environmentResultSetExtractor(Mappers$.MODULE$.environmentResultSetExtractor$default$1(), Mappers$.MODULE$.environmentResultSetExtractor$default$2()));
    }

    public Option<Environment> findByTitle(String environmentTitle) {
        Tuple2<String, Seq<Object>> tuple2 = EnvironmentSqlBuilder$.MODULE$.apply(EnvironmentSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).select().withEnvironmentTitle(environmentTitle).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.environmentResultSetExtractor(Mappers$.MODULE$.environmentResultSetExtractor$default$1(), Mappers$.MODULE$.environmentResultSetExtractor$default$2()));
    }

    public Option<Integer> findUidById(String environmentId) {
        String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(60).append("|SELECT ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()).append("\n          |FROM ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE()).append("\n          |WHERE ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()).append(" = :environmentId").toString())).stripMargin();
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentId"), (Object)package$.MODULE$.toPersistedId(environmentId))})), (Function1 & Serializable & scala.Serializable)rs -> package.CiUid$.MODULE$.apply(rs.getInt(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()))).headOption();
    }

    public Seq<Environment> search(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Seq)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.environmentSearchResultSetExtractor());
    }

    private String STMT_DELETE_ENVIRONMENTS_BY_ID() {
        return this.STMT_DELETE_ENVIRONMENTS_BY_ID;
    }

    public Try<Object> delete(String environmentId) {
        return (Try)this.sqlExec(this.STMT_DELETE_ENVIRONMENTS_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentId"), (Object)package$.MODULE$.toPersistedId(environmentId))})), ps -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ps.execute()));
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Integer> getLabelUids(Environment environment) {
        Map map;
        if (CollectionUtils.isEmpty(environment.getLabels())) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            void var3_3;
            Map<String, Integer> labelIdsToUids;
            Set labelIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(environment.getLabels()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set labelDiff = (Set)labelIds.diff((GenSet)(labelIdsToUids = this.environmentLabelPersistence().getUidsByIds((Iterable<String>)labelIds)).keySet());
            if (labelDiff.nonEmpty()) {
                throw new NotFoundException(new StringBuilder(31).append("Environment labels [").append(labelDiff.mkString(", ")).append("] not found").toString(), new Object[0]);
            }
            map = var3_3;
        }
        return map;
    }

    private Seq<Object> insertEnvToLabelReferences(Integer environmentUid, Set<Integer> labelUids) {
        String insertEnvToLabelStmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("INSERT INTO ").append(EnvironmentSchema$ENV_TO_LABEL$.MODULE$.TABLE()).append(" (\n         |").append(EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID()).append(",\n         |").append(EnvironmentSchema$ENV_TO_LABEL$.MODULE$.LABEL_UID()).append("\n         |)\n         |VALUES (\n         |:").append(EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID()).append(",\n         |:").append(EnvironmentSchema$ENV_TO_LABEL$.MODULE$.LABEL_UID()).append("\n         |)\n       ").toString())).stripMargin();
        return this.sqlBatch(insertEnvToLabelStmt, (Set<Map<String, Object>>)((Set)labelUids.map((Function1 & Serializable & scala.Serializable)labelUid -> Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID()), (Object)environmentUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENV_TO_LABEL$.MODULE$.LABEL_UID()), labelUid)})), Set$.MODULE$.canBuildFrom())));
    }

    private Seq<Object> updateEnvToLabelReferences(Environment environment, Integer environmentUid) {
        Map<String, Integer> labelIdsToUids = this.getLabelUids(environment);
        String deleteEnvToLabelRefsStmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n         |DELETE FROM ").append(EnvironmentSchema$ENV_TO_LABEL$.MODULE$.TABLE()).append("\n         | WHERE\n         | ").append(EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID()).append(" = :").append(EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID()).append("\n       ").toString())).stripMargin();
        this.sqlExec(deleteEnvToLabelRefsStmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID()), (Object)environmentUid)})), x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.execute()));
        return this.insertEnvToLabelReferences(environmentUid, (Set<Integer>)labelIdsToUids.valuesIterator().toSet());
    }

    public Map<String, Integer> getUidsByIds(Iterable<String> environmentIds) {
        String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(74).append("|SELECT ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()).append(", ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()).append("\n          |FROM ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE()).append("\n          |WHERE ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()).append(" IN (:environmentIds)\n       ").toString())).stripMargin();
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentIds"), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)environmentIds.map((Function1 & Serializable & scala.Serializable)id -> package$.MODULE$.toPersistedId((String)id), Iterable$.MODULE$.canBuildFrom())).asJava())})), (Function1 & Serializable & scala.Serializable)rs -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.ResultSetExtension((ResultSet)rs).getCiId(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID())), (Object)package.CiUid$.MODULE$.apply(rs.getInt(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID())))).toMap(Predef$.MODULE$.$conforms());
    }

    private void sanitizeEnvironmentInput(Environment environment) {
        environment.setTitle(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(environment.getTitle()), EnvironmentSchema$.MODULE$.TITLE_LENGTH()));
        environment.setDescription(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(environment.getDescription()), EnvironmentSchema$.MODULE$.DESCRIPTION_LENGTH()));
    }

    public static final /* synthetic */ boolean $anonfun$insert$2(ResultSet x$1) {
        return x$1.getInt(1) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$update$3(ResultSet x$3) {
        return x$3.getInt(1) > 0;
    }

    @Autowired
    public EnvironmentPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, CiIdService ciIdService, SecurablePersistence securablePersistence, EnvironmentStagePersistence environmentStagePersistence, EnvironmentLabelPersistence environmentLabelPersistence) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.ciIdService = ciIdService;
        this.securablePersistence = securablePersistence;
        this.environmentStagePersistence = environmentStagePersistence;
        this.environmentLabelPersistence = environmentLabelPersistence;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        this.STMT_INSERT_ENVIRONMENTS = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n       |INSERT INTO ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE()).append("\n       |(").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()).append(",\n       |").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()).append(",\n       |").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()).append(",\n       |").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION()).append(",\n       |").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID()).append(")\n       |VALUES\n       |(:").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()).append(",\n       |:").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()).append(",\n       |:").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()).append(",\n       |:").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION()).append(",\n       |:").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID()).append(")\n      ").toString())).stripMargin();
        this.STMT_EXISTS_BY_TITLE = new StringBuilder(32).append("SELECT COUNT(*) FROM ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE()).append(" WHERE ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()).append(" = :").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()).toString();
        this.STMT_UPDATE_ENVIRONMENTS = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("|UPDATE ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE()).append("\n        | SET\n        |  ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION()).append(" = :").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION()).append(",\n        |  ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()).append(" = :").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()).append(",\n        |  ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID()).append(" = :").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID()).append("\n        | WHERE\n        |  ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()).append(" = :").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()).append("\n        ").toString())).stripMargin();
        this.STMT_EXISTS_ANOTHER_ENV_WITH_TITLE = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(34).append("\n       |").append(this.STMT_EXISTS_BY_TITLE()).append("\n       |AND ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()).append(" <> :").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()).append("\n      ").toString())).stripMargin();
        this.STMT_DELETE_ENVIRONMENTS_BY_ID = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(47).append("|DELETE FROM ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE()).append("\n        | WHERE ").append(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()).append(" = :environmentId").toString())).stripMargin();
    }
}

