/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.repository.sql;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository;
import com.xebialabs.xlrelease.environments.repository.EnvironmentReservationRepository;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentReservationPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ColumnAliases$Environments$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.EnvironmentsWithReservationsSqlBuilder;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.EnvironmentsWithReservationsSqlBuilder$;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001\u0002\t\u0012\u0001yA\u0001\"\u000b\u0001\u0003\u0006\u0004%\u0019A\u000b\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005W!A1\t\u0001BC\u0002\u0013\rA\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003F\u0011!a\u0005A!A!\u0002\u0013i\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u0011]\u0003!\u0011!Q\u0001\naCQa\u0017\u0001\u0005\u0002qCQa\u001f\u0001\u0005BqDq!!\u001a\u0001\t\u0003\n9\u0007C\u0004\u0002v\u0001!\t%a\u001e\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0002\"9\u0011q\u0011\u0001\u0005B\u0005%\u0005bBAG\u0001\u0011\u0005\u0013q\u0012\u0005\b\u00033\u0003A\u0011IAN\u0005\r\u001a\u0016\u000f\\#om&\u0014xN\\7f]R\u0014Vm]3sm\u0006$\u0018n\u001c8SKB|7/\u001b;pefT!AE\n\u0002\u0007M\fHN\u0003\u0002\u0015+\u0005Q!/\u001a9pg&$xN]=\u000b\u0005Y9\u0012\u0001D3om&\u0014xN\\7f]R\u001c(B\u0001\r\u001a\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001b7\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0014\u0013\tA3C\u0001\u0011F]ZL'o\u001c8nK:$(+Z:feZ\fG/[8o%\u0016\u0004xn]5u_JL\u0018a\u00023jC2,7\r^\u000b\u0002WA\u0011Af\u0010\b\u0003[qr!A\f\u001e\u000f\u0005=BdB\u0001\u00198\u001d\t\tdG\u0004\u00023k5\t1G\u0003\u00025;\u00051AH]8pizJ\u0011\u0001H\u0005\u00035mI!\u0001G\r\n\u0005e:\u0012A\u00013c\u0013\t\u00112H\u0003\u0002:/%\u0011QHP\u0001\u000b'Fd')^5mI\u0016\u0014(B\u0001\n<\u0013\t\u0001\u0015IA\u0004ES\u0006dWm\u0019;\u000b\u0005ur\u0014\u0001\u00033jC2,7\r\u001e\u0011\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002\u000bB\u0011a)S\u0007\u0002\u000f*\u0011\u0001jF\u0001\bg\u0016\u0014h/[2f\u0013\tQuIA\u0006DS&#7+\u001a:wS\u000e,\u0017\u0001D2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\u0013!F1qa2L7-\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003M9K!aT\n\u0003+\u0005\u0003\b\u000f\\5dCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u00061RM\u001c<je>tW.\u001a8u!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002S+6\t1K\u0003\u0002U#\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\t16K\u0001\fF]ZL'o\u001c8nK:$\b+\u001a:tSN$XM\\2f\u0003\u0005*gN^5s_:lWM\u001c;SKN,'O^1uS>t\u0007+\u001a:tSN$XM\\2f!\t\u0011\u0016,\u0003\u0002['\n\tSI\u001c<je>tW.\u001a8u%\u0016\u001cXM\u001d<bi&|g\u000eU3sg&\u001cH/\u001a8dK\u00061A(\u001b8jiz\"\u0012!\u0018\u000b\u0007=\u0002\u001cH/\u001e<\u0011\u0005}\u0003Q\"A\t\t\u000b%B\u00019A\u0016)\t\u0001\u0014\u0007/\u001d\t\u0003G:l\u0011\u0001\u001a\u0006\u0003K\u001a\f!\"\u00198o_R\fG/[8o\u0015\t9\u0007.A\u0004gC\u000e$xN]=\u000b\u0005%T\u0017!\u00022fC:\u001c(BA6m\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A7\u0002\u0007=\u0014x-\u0003\u0002pI\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002e\u00069\u0002\u0010\u001c:SKB|7/\u001b;pef\u001c\u0016\u000f\u001c#jC2,7\r\u001e\u0005\u0006\u0007\"\u0001\u001d!\u0012\u0005\u0006\u0019\"\u0001\r!\u0014\u0005\u0006!\"\u0001\r!\u0015\u0005\u0006/\"\u0001\r\u0001\u0017\u0015\u0003\u0011a\u0004\"aY=\n\u0005i$'!C!vi><\u0018N]3e\u0003\u0019\u0019X-\u0019:dQR)Q0!\r\u0002JA9a0!\u0002\u0002\f\u0005eabA@\u0002\u0002A\u0011!'I\u0005\u0004\u0003\u0007\t\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\b\u0005%!aA'ba*\u0019\u00111A\u0011\u0011\t\u00055\u0011QC\u0007\u0003\u0003\u001fQ1AFA\t\u0015\r\t\u0019bF\u0001\u0007I>l\u0017-\u001b8\n\t\u0005]\u0011q\u0002\u0002\f\u000b:4\u0018N]8o[\u0016tG\u000f\u0005\u0004\u0002\u001c\u0005\u0015\u00121\u0006\b\u0005\u0003;\t\tCD\u00023\u0003?I\u0011AI\u0005\u0004\u0003G\t\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003O\tICA\u0002TKFT1!a\t\"!\u0011\ti!!\f\n\t\u0005=\u0012q\u0002\u0002\u0017\u000b:4\u0018N]8o[\u0016tGOU3tKJ4\u0018\r^5p]\"9\u00111G\u0005A\u0002\u0005U\u0012a\u00024jYR,'o\u001d\t\u0005\u0003o\t)%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u00191\u0017\u000e\u001c;fe*!\u0011qHA!\u0003\t1\u0018GC\u0002\u0002D]\t1!\u00199j\u0013\u0011\t9%!\u000f\u0003%I+7/\u001a:wCRLwN\u001c$jYR,'o\u001d\u0005\b\u0003\u0017J\u0001\u0019AA'\u0003\u0011\u0001\u0018mZ3\u0011\t\u0005=\u00131K\u0007\u0003\u0003#R!\u0001F\f\n\t\u0005U\u0013\u0011\u000b\u0002\u0005!\u0006<W\rK\u0002\n\u00033\u0002B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?r\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:LA!a\u0019\u0002^\tQ\u0011j\u001d*fC\u0012|e\u000e\\=\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$B!a\u000b\u0002j!9\u00111\u000e\u0006A\u0002\u00055\u0014\u0001G3om&\u0014xN\\7f]R\u0014Vm]3sm\u0006$\u0018n\u001c8JIB\u0019a0a\u001c\n\t\u0005E\u0014\u0011\u0002\u0002\u0007'R\u0014\u0018N\\4)\u0007)\tI&\u0001\fhKR\fE\u000e\u001c$pe\u0016sg/\u001b:p]6,g\u000e^%e)\u0011\tI\"!\u001f\t\u000f\u0005m4\u00021\u0001\u0002n\u0005iQM\u001c<je>tW.\u001a8u\u0013\u0012D3aCA-\u0003\u0019\u0019'/Z1uKR!\u00111FAB\u0011\u001d\t)\t\u0004a\u0001\u0003W\ta#\u001a8wSJ|g.\\3oiJ+7/\u001a:wCRLwN\\\u0001\u0007kB$\u0017\r^3\u0015\t\u0005-\u00121\u0012\u0005\b\u0003\u000bk\u0001\u0019AA\u0016\u0003\u0019!W\r\\3uKR!\u0011\u0011SAL!\r\u0001\u00131S\u0005\u0004\u0003+\u000b#\u0001B+oSRDq!a\u001b\u000f\u0001\u0004\ti'\u0001\u0017fq&\u001cHo\u001d\"z\u000b:4\u0018N]8o[\u0016tG/\u00133B]\u0012\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8JI\u0006sG\rR1uKRA\u0011QTAR\u0003K\u000bI\u000bE\u0002!\u0003?K1!!)\"\u0005\u001d\u0011un\u001c7fC:Dq!a\u001f\u0010\u0001\u0004\ti\u0007C\u0004\u0002(>\u0001\r!!\u001c\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0011\u001d\tYk\u0004a\u0001\u0003[\u000bA\u0001Z1uKB!\u0011qVA]\u001b\t\t\tL\u0003\u0003\u00024\u0006U\u0016\u0001B;uS2T!!a.\u0002\t)\fg/Y\u0005\u0005\u0003w\u000b\tL\u0001\u0003ECR,\u0007f\u0001\u0001\u0002@B!\u0011\u0011YAd\u001b\t\t\u0019MC\u0002\u0002F*\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tI-a1\u0003\u0015I+\u0007o\\:ji>\u0014\u0018\u0010K\u0002\u0001\u0003\u001b\u0004B!a\u0017\u0002P&!\u0011\u0011[A/\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlEnvironmentReservationRepository
implements EnvironmentReservationRepository {
    private final SqlBuilder.Dialect dialect;
    private final CiIdService ciIdService;
    private final EnvironmentReservationPersistence environmentReservationPersistence;

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    @IsReadOnly
    public Map<Environment, Seq<EnvironmentReservation>> search(ReservationFilters filters, Page page) {
        EnvironmentsWithReservationsSqlBuilder query = EnvironmentsWithReservationsSqlBuilder$.MODULE$.apply(EnvironmentsWithReservationsSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).orderBy(ColumnAliases$Environments$.MODULE$.CI_UID()).limitAndOffset(page.resultsPerPage(), page.offset());
        Option$.MODULE$.apply((Object)filters).foreach((Function1 & Serializable & scala.Serializable)f -> {
            SqlEnvironmentReservationRepository.$anonfun$search$1(query, f);
            return BoxedUnit.UNIT;
        });
        return this.environmentReservationPersistence.search(query.build());
    }

    @Override
    @IsReadOnly
    public EnvironmentReservation findById(String environmentReservationId) {
        return (EnvironmentReservation)((Object)this.environmentReservationPersistence.findById(environmentReservationId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(36).append("Environment reservation [").append(environmentReservationId).append("] not found").toString(), new Object[0]);
        }));
    }

    @Override
    @IsReadOnly
    public Seq<EnvironmentReservation> getAllForEnvironmentId(String environmentId) {
        Environment tmpEnvironment = (Environment)new Environment().getType().getDescriptor().newInstance(environmentId);
        EnvironmentsWithReservationsSqlBuilder query = EnvironmentsWithReservationsSqlBuilder$.MODULE$.apply(EnvironmentsWithReservationsSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).withEnvironmentId(environmentId);
        return (Seq)this.environmentReservationPersistence.search(query.build()).getOrElse((Object)tmpEnvironment, (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    @Override
    public EnvironmentReservation create(EnvironmentReservation environmentReservation) {
        String resId = this.environmentReservationPersistence.insert(environmentReservation);
        return this.findById(resId);
    }

    @Override
    public EnvironmentReservation update(EnvironmentReservation environmentReservation) {
        this.environmentReservationPersistence.update(environmentReservation);
        return this.findById(environmentReservation.getId());
    }

    @Override
    public void delete(String environmentReservationId) {
        this.environmentReservationPersistence.delete(environmentReservationId);
    }

    @Override
    public boolean existsByEnvironmentIdAndApplicationIdAndDate(String environmentId, String applicationId, Date date) {
        return this.environmentReservationPersistence.exists(environmentId, applicationId, date);
    }

    public static final /* synthetic */ void $anonfun$search$1(EnvironmentsWithReservationsSqlBuilder query$1, ReservationFilters f) {
        Option$.MODULE$.apply((Object)f.getEnvironmentTitle()).foreach((Function1 & Serializable & scala.Serializable)title -> query$1.withEnvironmentTitleLike((String)title));
        Option$.MODULE$.apply(f.getStages()).foreach((Function1 & Serializable & scala.Serializable)stages -> query$1.withStageTitles((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(stages).asScala())));
        Option$.MODULE$.apply(f.getApplications()).foreach((Function1 & Serializable & scala.Serializable)apps -> query$1.withApplicationTitles((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(apps).asScala())));
        Option$.MODULE$.apply(f.getLabels()).foreach((Function1 & Serializable & scala.Serializable)labels -> query$1.withLabelTitles((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(labels).asScala())));
        Option$.MODULE$.apply((Object)f.getFrom()).foreach((Function1 & Serializable & scala.Serializable)date -> query$1.from((Date)date));
        Option$.MODULE$.apply((Object)f.getTo()).foreach((Function1 & Serializable & scala.Serializable)date -> query$1.to((Date)date));
    }

    @Autowired
    public SqlEnvironmentReservationRepository(@Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, CiIdService ciIdService, ApplicationRepository applicationRepository, EnvironmentPersistence environmentPersistence, EnvironmentReservationPersistence environmentReservationPersistence) {
        this.dialect = dialect;
        this.ciIdService = ciIdService;
        this.environmentReservationPersistence = environmentReservationPersistence;
    }
}

