/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationCreatedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationDeletedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.EnvironmentReservationRepository;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import com.xebialabs.xlrelease.environments.service.EnvironmentService;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u00015\u0011Q$\u00128wSJ|g.\\3oiJ+7/\u001a:wCRLwN\\*feZL7-\u001a\u0006\u0003\u0007\u0011\tqa]3sm&\u001cWM\u0003\u0002\u0006\r\u0005aQM\u001c<je>tW.\u001a8ug*\u0011q\u0001C\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0003\u0006\u0002\u0013a,'-[1mC\n\u001c(\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+ii\u0011A\u0006\u0006\u0003/a\tQa\u001d7gi)T\u0011!G\u0001\tOJL'P\u001f7fI&\u00111D\u0006\u0002\b\u0019><w-\u001b8h\u0011!i\u0002A!A!\u0002\u0013q\u0012\u0001I3om&\u0014xN\\7f]R\u0014Vm]3sm\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0003\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002$A\t\u0001SI\u001c<je>tW.\u001a8u%\u0016\u001cXM\u001d<bi&|gNU3q_NLGo\u001c:z\u0011!)\u0003A!A!\u0002\u00131\u0013AE3om&\u0014xN\\7f]R\u001cVM\u001d<jG\u0016\u0004\"a\n\u0015\u000e\u0003\tI!!\u000b\u0002\u0003%\u0015sg/\u001b:p]6,g\u000e^*feZL7-\u001a\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u0005\u0011\u0012\r\u001d9mS\u000e\fG/[8o'\u0016\u0014h/[2f!\t9S&\u0003\u0002/\u0005\t\u0011\u0012\t\u001d9mS\u000e\fG/[8o'\u0016\u0014h/[2f\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014\u0001C3wK:$()^:\u0011\u0005I*T\"A\u001a\u000b\u0005Q2\u0011AB3wK:$8/\u0003\u00027g\t\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\u0015Q4\bP\u001f?!\t9\u0003\u0001C\u0003\u001eo\u0001\u0007a\u0004C\u0003&o\u0001\u0007a\u0005C\u0003,o\u0001\u0007A\u0006C\u00031o\u0001\u0007\u0011\u0007\u000b\u00028\u0001B\u0011\u0011\tT\u0007\u0002\u0005*\u00111\tR\u0001\u000bC:tw\u000e^1uS>t'BA#G\u0003\u001d1\u0017m\u0019;pefT!a\u0012%\u0002\u000b\t,\u0017M\\:\u000b\u0005%S\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003-\u000b1a\u001c:h\u0013\ti%IA\u0005BkR|w/\u001b:fI\")q\n\u0001C\u0001!\u0006\u00112/Z1sG\"\u0014Vm]3sm\u0006$\u0018n\u001c8t)\t\tf\r\u0005\u0003S/f\u0003W\"A*\u000b\u0005Q+\u0016\u0001B;uS2T\u0011AV\u0001\u0005U\u00064\u0018-\u0003\u0002Y'\n\u0019Q*\u00199\u0011\u0005isV\"A.\u000b\u0005\u0015a&BA/\u0007\u0003\u0019!w.\\1j]&\u0011ql\u0017\u0002\f\u000b:4\u0018N]8o[\u0016tG\u000fE\u0002SC\u000eL!AY*\u0003\t1K7\u000f\u001e\t\u00035\u0012L!!Z.\u0003-\u0015sg/\u001b:p]6,g\u000e\u001e*fg\u0016\u0014h/\u0019;j_:DQa\u001a(A\u0002!\fqAZ5mi\u0016\u00148\u000f\u0005\u0002ja6\t!N\u0003\u0002lY\u00061a-\u001b7uKJT!!\u001c8\u0002\u0005Y\f$BA8\u0007\u0003\r\t\u0007/[\u0005\u0003c*\u0014!CU3tKJ4\u0018\r^5p]\u001aKG\u000e^3sg\"\u0012aj\u001d\t\u0003ijl\u0011!\u001e\u0006\u0003\u0007ZT!a\u001e=\u0002\u000f5,GO]5dg*\u0011\u0011PC\u0001\tG>$\u0017\r[1mK&\u001110\u001e\u0002\u0006)&lW\r\u001a\u0005\u0006{\u0002!\tA`\u0001\u0014M&tGMU3tKJ4\u0018\r^5p]\nK\u0018\n\u001a\u000b\u0003G~Dq!!\u0001}\u0001\u0004\t\u0019!\u0001\rf]ZL'o\u001c8nK:$(+Z:feZ\fG/[8o\u0013\u0012\u0004B!!\u0002\u0002\u00149!\u0011qAA\b!\r\tI\u0001E\u0007\u0003\u0003\u0017Q1!!\u0004\r\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0003\t\u0002\rA\u0013X\rZ3g\u0013\u0011\t)\"a\u0006\u0003\rM#(/\u001b8h\u0015\r\t\t\u0002\u0005\u0015\u0003yNDq!!\b\u0001\t\u0003\ty\"\u0001\u0010hKR\u0014Vm]3sm\u0006$\u0018n\u001c8t\u0005f,eN^5s_:lWM\u001c;JIR\u0019\u0001-!\t\t\u0011\u0005\r\u00121\u0004a\u0001\u0003\u0007\tQ\"\u001a8wSJ|g.\\3oi&#\u0007fAA\u000eg\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0012!E2sK\u0006$XMU3tKJ4\u0018\r^5p]R\u00191-!\f\t\u000f\u0005=\u0012q\u0005a\u0001G\u00061RM\u001c<je>tW.\u001a8u%\u0016\u001cXM\u001d<bi&|g\u000eK\u0002\u0002(MDq!!\u000e\u0001\t\u0003\t9$A\tva\u0012\fG/\u001a*fg\u0016\u0014h/\u0019;j_:$2aYA\u001d\u0011\u001d\ty#a\rA\u0002\rD3!a\rt\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\n\u0011\u0003Z3mKR,'+Z:feZ\fG/[8o)\u0011\t\u0019%!\u0013\u0011\u0007=\t)%C\u0002\u0002HA\u0011A!\u00168ji\"A\u0011\u0011AA\u001f\u0001\u0004\t\u0019\u0001K\u0002\u0002>MDq!a\u0014\u0001\t\u0003\t\t&A\tfq&\u001cHo\u001d*fg\u0016\u0014h/\u0019;j_:$b!a\u0015\u0002Z\u0005m\u0003cA\b\u0002V%\u0019\u0011q\u000b\t\u0003\u000f\t{w\u000e\\3b]\"A\u00111EA'\u0001\u0004\t\u0019\u0001\u0003\u0005\u0002^\u00055\u0003\u0019AA\u0002\u00035\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JI\"\u001a\u0011QJ:\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f\u0005Aa/\u00197jI\u0006$X\r\u0006\u0003\u0002D\u0005\u001d\u0004bBA\u0018\u0003C\u0002\ra\u0019\u0005\b\u0003W\u0002A\u0011BA7\u000351\u0018\r\\5eCR,G)\u0019;fgR!\u00111IA8\u0011\u001d\ty#!\u001bA\u0002\rDq!a\u001d\u0001\t\u0013\t)(\u0001\u0007wC2LG-\u0019;f\u001d>$X\r\u0006\u0003\u0002D\u0005]\u0004bBA\u0018\u0003c\u0002\ra\u0019\u0005\b\u0003w\u0002A\u0011BA?\u0003Q1\u0018\r\\5eCR,\u0017\t\u001d9mS\u000e\fG/[8ogR!\u00111IA@\u0011\u001d\ty#!\u001fA\u0002\rD3\u0001AAB!\u0011\t))a#\u000e\u0005\u0005\u001d%bAAE\u0011\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u00055\u0015q\u0011\u0002\b'\u0016\u0014h/[2f\u0001")
public class EnvironmentReservationService
implements Logging {
    private final EnvironmentReservationRepository environmentReservationRepository;
    private final ApplicationService applicationService;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentReservationService environmentReservationService = this;
        synchronized (environmentReservationService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public java.util.Map<Environment, List<EnvironmentReservation>> searchReservations(ReservationFilters filters) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.environmentReservationRepository.search(filters, package$.MODULE$.defaultPage()).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter(x$1).asJava())).asJava();
    }

    @Timed
    public EnvironmentReservation findReservationById(String environmentReservationId) {
        return this.environmentReservationRepository.findById(environmentReservationId);
    }

    @Timed
    public List<EnvironmentReservation> getReservationsByEnvironmentId(String environmentId) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.environmentReservationRepository.getAllForEnvironmentId(environmentId)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public EnvironmentReservation createReservation(EnvironmentReservation environmentReservation) {
        void var2_2;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating a new environment reservation"})).s((Seq)Nil$.MODULE$));
        this.validate(environmentReservation);
        EnvironmentReservation reservation = this.environmentReservationRepository.create(environmentReservation);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationCreatedEvent(reservation));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public EnvironmentReservation updateReservation(EnvironmentReservation environmentReservation) {
        void var2_2;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating environment reservation [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environmentReservation})));
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environmentReservation);
        EnvironmentReservation reservation = this.environmentReservationRepository.update(environmentReservation);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationUpdatedEvent(reservation));
        return var2_2;
    }

    @Timed
    public void deleteReservation(String environmentReservationId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting environment reservation [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environmentReservationId})));
        EnvironmentReservation reservation = this.environmentReservationRepository.findById(environmentReservationId);
        this.environmentReservationRepository.delete(environmentReservationId);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationDeletedEvent(reservation));
    }

    @Timed
    public boolean existsReservation(String environmentId, String applicationId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking reservation for environmentId [", "] and applicationId [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environmentId, applicationId})));
        return this.environmentReservationRepository.existsByEnvironmentIdAndApplicationIdAndDate(environmentId, applicationId, new Date());
    }

    private void validate(EnvironmentReservation environmentReservation) {
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environmentReservation.getEnvironment()).exists((Function1 & Serializable & scala.Serializable)env -> BoxesRunTime.boxToBoolean((boolean)EnvironmentReservationService.$anonfun$validate$1(env))), (String)"Environment ID is required", (Object[])new Object[0]);
        this.validateDates(environmentReservation);
        this.validateNote(environmentReservation);
        this.validateApplications(environmentReservation);
    }

    private void validateDates(EnvironmentReservation environmentReservation) {
        Date startDate = environmentReservation.getStartDate();
        Date endDate = environmentReservation.getEndDate();
        Checks.checkArgument((startDate != null ? 1 : 0) != 0, (String)"Start date is required", (Object[])new Object[0]);
        Checks.checkArgument((endDate != null ? 1 : 0) != 0, (String)"End date is required", (Object[])new Object[0]);
        Checks.checkArgument((boolean)startDate.before(endDate), (String)"Start date must be before the end date", (Object[])new Object[0]);
    }

    private void validateNote(EnvironmentReservation environmentReservation) {
        block0: {
            if (environmentReservation.getNote() == null) break block0;
            Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getNote()), (String)"Note cannot be blank", (Object[])new Object[0]);
        }
    }

    private void validateApplications(EnvironmentReservation environmentReservation) {
        if (CollectionUtils.isNotEmpty(environmentReservation.getApplications())) {
            Set allowedAppIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.applicationService.getApplicationsDeployableOnEnvironment(environmentReservation.getEnvironment().getId())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set givenAppIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(environmentReservation.getApplications()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set diff = (Set)givenAppIds.diff((GenSet)allowedAppIds);
            if (diff.nonEmpty()) {
                Tuple2 tuple2 = diff.splitAt(10);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Set first10 = (Set)tuple2._1();
                Set rest = (Set)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)first10, (Object)rest);
                Tuple2 tuple23 = tuple22;
                Set first102 = (Set)tuple23._1();
                Set rest2 = (Set)tuple23._2();
                throw new Checks.IncorrectArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |The following applications are not deployable on environment [", "]:\n             |[", "] ", "\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environmentReservation.getEnvironment().getId(), first102.mkString(", "), rest2.nonEmpty() ? ", and more" : BoxedUnit.UNIT})))).stripMargin(), new Object[0]);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(Environment env) {
        return StringUtils.hasText((String)env.getId());
    }

    @Autowired
    public EnvironmentReservationService(EnvironmentReservationRepository environmentReservationRepository, EnvironmentService environmentService, ApplicationService applicationService, XLReleaseEventBus eventBus) {
        this.environmentReservationRepository = environmentReservationRepository;
        this.applicationService = applicationService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

