/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationCreatedEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationDeletedEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository;
import com.xebialabs.xlrelease.environments.service.ApplicationSecurity;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u00015\u0011!#\u00119qY&\u001c\u0017\r^5p]N+'O^5dK*\u00111\u0001B\u0001\bg\u0016\u0014h/[2f\u0015\t)a!\u0001\u0007f]ZL'o\u001c8nK:$8O\u0003\u0002\b\u0011\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012!F1qa2L7-\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\t!B]3q_NLGo\u001c:z\u0013\tY\u0002DA\u000bBaBd\u0017nY1uS>t'+\u001a9pg&$xN]=\t\u0011u\u0001!\u0011!Q\u0001\ny\t1#\u00199qY&\u001c\u0017\r^5p]N+7-\u001e:jif\u0004\"a\b\u0011\u000e\u0003\tI!!\t\u0002\u0003'\u0005\u0003\b\u000f\\5dCRLwN\\*fGV\u0014\u0018\u000e^=\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002KA\u0011a%K\u0007\u0002O)\u0011\u0001FB\u0001\u0007KZ,g\u000e^:\n\u0005):#!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\"AA\u0006\u0001B\u0001B\u0003%Q%A\u0005fm\u0016tGOQ;tA!)a\u0006\u0001C\u0001_\u00051A(\u001b8jiz\"B\u0001M\u00193gA\u0011q\u0004\u0001\u0005\u0006+5\u0002\rA\u0006\u0005\u0006;5\u0002\rA\b\u0005\u0006G5\u0002\r!\n\u0015\u0003[U\u0002\"AN!\u000e\u0003]R!\u0001O\u001d\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002;w\u00059a-Y2u_JL(B\u0001\u001f>\u0003\u0015\u0011W-\u00198t\u0015\tqt(A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0001\u0015aA8sO&\u0011!i\u000e\u0002\n\u0003V$xn^5sK\u0012DQ\u0001\u0012\u0001\u0005\u0002\u0015\u000b!c]3be\u000eD\u0017\t\u001d9mS\u000e\fG/[8ogR\u0011a)\u0016\t\u0004\u000f2sU\"\u0001%\u000b\u0005%S\u0015\u0001B;uS2T\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n!A*[:u!\ty5+D\u0001Q\u0015\t)\u0011K\u0003\u0002S\r\u00051Am\\7bS:L!\u0001\u0016)\u0003\u0017\u0005\u0003\b\u000f\\5dCRLwN\u001c\u0005\u0006-\u000e\u0003\raV\u0001\u0013CB\u0004H.[2bi&|gNR5mi\u0016\u00148\u000f\u0005\u0002Y?6\t\u0011L\u0003\u0002[7\u00061a-\u001b7uKJT!\u0001X/\u0002\u0005Y\f$B\u00010\u0007\u0003\r\t\u0007/[\u0005\u0003Af\u0013!#\u00119qY&\u001c\u0017\r^5p]\u001aKG\u000e^3sg\"\u00121I\u0019\t\u0003G&l\u0011\u0001\u001a\u0006\u0003q\u0015T!AZ4\u0002\u000f5,GO]5dg*\u0011\u0001NC\u0001\tG>$\u0017\r[1mK&\u0011!\u000e\u001a\u0002\u0006)&lW\r\u001a\u0005\u0006Y\u0002!\t!\\\u0001\u0014M&tG-\u00119qY&\u001c\u0017\r^5p]\nK\u0018\n\u001a\u000b\u0003\u001d:DQa\\6A\u0002A\fQ\"\u00199qY&\u001c\u0017\r^5p]&#\u0007CA9y\u001d\t\u0011h\u000f\u0005\u0002t!5\tAO\u0003\u0002v\u0019\u00051AH]8pizJ!a\u001e\t\u0002\rA\u0013X\rZ3g\u0013\tI(P\u0001\u0004TiJLgn\u001a\u0006\u0003oBA#a\u001b2\t\u000bu\u0004A\u0011\u0001@\u0002#\r\u0014X-\u0019;f\u0003B\u0004H.[2bi&|g\u000e\u0006\u0002O\u007f\"1\u0011\u0011\u0001?A\u00029\u000b1\"\u00199qY&\u001c\u0017\r^5p]\"\u0012AP\u0019\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0003E)\b\u000fZ1uK\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0004\u001d\u0006-\u0001bBA\u0001\u0003\u000b\u0001\rA\u0014\u0015\u0004\u0003\u000b\u0011\u0007bBA\t\u0001\u0011\u0005\u00111C\u0001\u0012I\u0016dW\r^3BaBd\u0017nY1uS>tG\u0003BA\u000b\u00037\u00012aDA\f\u0013\r\tI\u0002\u0005\u0002\u0005+:LG\u000f\u0003\u0004p\u0003\u001f\u0001\r\u0001\u001d\u0015\u0004\u0003\u001f\u0011\u0007bBA\u0011\u0001\u0011\u0005\u00111E\u0001'O\u0016$\u0018\t\u001d9mS\u000e\fG/[8og\u0012+\u0007\u000f\\8zC\ndWm\u00148F]ZL'o\u001c8nK:$Hc\u0001$\u0002&!9\u0011qEA\u0010\u0001\u0004\u0001\u0018!D3om&\u0014xN\\7f]RLE\rK\u0002\u0002 \tDq!!\f\u0001\t\u0013\ty#A\u0007wC2LG-\u0019;f)&$H.\u001a\u000b\u0005\u0003+\t\t\u0004C\u0004\u0002\u0002\u0005-\u0002\u0019\u0001()\u0007\u0001\t)\u0004\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tY$P\u0001\u000bgR,'/Z8usB,\u0017\u0002BA \u0003s\u0011qaU3sm&\u001cW\r")
public class ApplicationService {
    private final ApplicationRepository applicationRepository;
    private final ApplicationSecurity applicationSecurity;
    private final XLReleaseEventBus eventBus;

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public List<Application> searchApplications(ApplicationFilters applicationFilters) {
        this.applicationSecurity.checkView();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.applicationRepository.searchApplications(applicationFilters, package$.MODULE$.defaultPage())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application findApplicationById(String applicationId) {
        void var2_2;
        this.applicationSecurity.checkView();
        Application application = this.applicationRepository.findApplicationById(applicationId);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application createApplication(Application application) {
        void var2_2;
        this.applicationSecurity.checkCreate();
        this.validateTitle(application);
        Application createdApplication = this.applicationRepository.createApplication(application);
        this.eventBus().publish((XLReleaseEvent)new ApplicationCreatedEvent(createdApplication));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application updateApplication(Application application) {
        void var2_2;
        this.applicationSecurity.checkEdit();
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validateTitle(application);
        Application updatedApplication = this.applicationRepository.updateApplication(application);
        this.eventBus().publish((XLReleaseEvent)new ApplicationUpdatedEvent(updatedApplication));
        return var2_2;
    }

    @Timed
    public void deleteApplication(String applicationId) {
        this.applicationSecurity.checkEdit();
        Application application = this.applicationRepository.findApplicationById(applicationId);
        this.applicationRepository.deleteApplication(applicationId);
        this.eventBus().publish((XLReleaseEvent)new ApplicationDeletedEvent(application));
    }

    @Timed
    public List<Application> getApplicationsDeployableOnEnvironment(String environmentId) {
        this.applicationSecurity.checkView();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.applicationRepository.getApplicationsDeployableOnEnvironment(environmentId)).asJava();
    }

    private void validateTitle(Application application) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    @Autowired
    public ApplicationService(ApplicationRepository applicationRepository, ApplicationSecurity applicationSecurity, XLReleaseEventBus eventBus) {
        this.applicationRepository = applicationRepository;
        this.applicationSecurity = applicationSecurity;
        this.eventBus = eventBus;
    }
}

