/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.Mappers$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ApplicationSqlBuilder$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$APPLICATIONS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENVIRONMENTS$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.SecurablePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.package;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@Profile(value={"sql"})
@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u0001\u0003\u0001E\u0011a#\u00119qY&\u001c\u0017\r^5p]B+'o]5ti\u0016t7-\u001a\u0006\u0003\u0007\u0011\t1\u0002]3sg&\u001cH/\u001a8dK*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u0013)\tA\"\u001a8wSJ|g.\\3oiNT!a\u0003\u0007\u0002\u0013ad'/\u001a7fCN,'BA\u0007\u000f\u0003%AXMY5bY\u0006\u00147OC\u0001\u0010\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eiR\"\u0001\u000e\u000b\u0005\rY\"BA\u0003\u001d\u0015\t9!\"\u0003\u0002\u001f5\t\u0011\u0002+\u001a:tSN$XM\\2f'V\u0004\bo\u001c:u\u0011!\u0001\u0003A!b\u0001\n\u0007\t\u0013\u0001\u00046eE\u000e$V-\u001c9mCR,W#\u0001\u0012\u0011\u0005\rbS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001B2pe\u0016T!a\n\u0015\u0002\t)$'m\u0019\u0006\u0003S)\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002W\u0005\u0019qN]4\n\u00055\"#\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0011!\t\u0004A!b\u0001\n\u0007\u0011\u0014a\u00023jC2,7\r^\u000b\u0002gA\u0011Ag\u0012\b\u0003k\u0011s!A\u000e\"\u000f\u0005]\u0002eB\u0001\u001d@\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005\u0005S\u0011A\u00013c\u0013\t)1I\u0003\u0002B\u0015%\u0011QIR\u0001\u000b'Fd')^5mI\u0016\u0014(BA\u0003D\u0013\tA\u0015JA\u0004ES\u0006dWm\u0019;\u000b\u0005\u00153\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\u0011\u0011L\u0017\r\\3di\u0002B\u0001\"\u0014\u0001\u0003\u0006\u0004%\u0019AT\u0001\fG&LEmU3sm&\u001cW-F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011&\"A\u0004tKJ4\u0018nY3\n\u0005Q\u000b&aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016D\u0001B\u0016\u0001\u0003\u0002\u0003\u0006IaT\u0001\rG&LEmU3sm&\u001cW\r\t\u0005\t1\u0002\u0011)\u0019!C\u00013\u00061RM\u001c<je>tW.\u001a8u!\u0016\u00148/[:uK:\u001cW-F\u0001[!\tYF,D\u0001\u0003\u0013\ti&A\u0001\fF]ZL'o\u001c8nK:$\b+\u001a:tSN$XM\\2f\u0011!y\u0006A!A!\u0002\u0013Q\u0016aF3om&\u0014xN\\7f]R\u0004VM]:jgR,gnY3!\u0011!\t\u0007A!b\u0001\n\u0003\u0011\u0017\u0001F:fGV\u0014\u0018M\u00197f!\u0016\u00148/[:uK:\u001cW-F\u0001d!\tIB-\u0003\u0002f5\t!2+Z2ve\u0006\u0014G.\u001a)feNL7\u000f^3oG\u0016D\u0001b\u001a\u0001\u0003\u0002\u0003\u0006IaY\u0001\u0016g\u0016\u001cWO]1cY\u0016\u0004VM]:jgR,gnY3!\u0011\u0015I\u0007\u0001\"\u0001k\u0003\u0019a\u0014N\\5u}Q\t1\u000eF\u0005m[r\f\t!a\u0001\u0002\u0006A\u00111\f\u0001\u0005\u0006A!\u0004\u001dA\t\u0015\u0005[>L(\u0010\u0005\u0002qo6\t\u0011O\u0003\u0002sg\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005Q,\u0018a\u00024bGR|'/\u001f\u0006\u0003m\"\nQAY3b]NL!\u0001_9\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%A>\u00023ad'OU3q_NLGo\u001c:z\u0015\u0012\u00147\rV3na2\fG/\u001a\u0005\u0006c!\u0004\u001da\r\u0015\u0005y>Lh0I\u0001\u0000\u0003]AHN\u001d*fa>\u001c\u0018\u000e^8ssN\u000bH\u000eR5bY\u0016\u001cG\u000fC\u0003NQ\u0002\u000fq\nC\u0003YQ\u0002\u0007!\fC\u0003bQ\u0002\u00071\rK\u0002i\u0003\u0013\u00012\u0001]A\u0006\u0013\r\ti!\u001d\u0002\n\u0003V$xn^5sK\u0012D\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\u00021M#V\nV0J\u001dN+%\u000bV0B!Bc\u0015jQ!U\u0013>s5+\u0006\u0002\u0002\u0016A!\u0011qCA\u0010\u001d\u0011\tI\"a\u0007\u0011\u0005i\"\u0012bAA\u000f)\u00051\u0001K]3eK\u001aLA!!\t\u0002$\t11\u000b\u001e:j]\u001eT1!!\b\u0015\u0011!\t9\u0003\u0001Q\u0001\n\u0005U\u0011!G*U\u001bR{\u0016JT*F%R{\u0016\t\u0015)M\u0013\u000e\u000bE+S(O'\u0002B\u0011\"a\u000b\u0001\u0005\u0004%I!a\u0005\u0002?M#V\nV0F1&\u001bFkU0C3~#\u0016\n\u0016'F?&;ej\u0014*F\u0007\u0006\u001bV\t\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u000b\u0003\u0001\u001aF+\u0014+`\u000bbK5\u000bV*`\u0005f{F+\u0013+M\u000b~KuIT(S\u000b\u000e\u000b5+\u0012\u0011\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u00051\u0011N\\:feR$B!a\u000e\u0002RA!\u0011\u0011HA&\u001d\u0011\tY$a\u0012\u000f\t\u0005u\u0012Q\t\b\u0005\u0003\u007f\t\u0019ED\u00028\u0003\u0003J!a\u0002\u0006\n\u0005\u0015a\u0012BA\u0002\u001c\u0013\r\tIEG\u0001\u0005\u0007&LE-\u0003\u0003\u0002N\u0005=#\u0001B\"j\u0013\u0012T1!!\u0013\u001b\u0011!\t\u0019&!\rA\u0002\u0005U\u0013aC1qa2L7-\u0019;j_:\u0004B!a\u0016\u0002`5\u0011\u0011\u0011\f\u0006\u0004\u0013\u0005m#bAA/\u0015\u00051Am\\7bS:LA!!\u0019\u0002Z\tY\u0011\t\u001d9mS\u000e\fG/[8o\u0011%\t)\u0007\u0001b\u0001\n\u0013\t\u0019\"\u0001\rT)6#v,\u0016)E\u0003R+u,\u0011)Q\u0019&\u001b\u0015\tV%P\u001dNC\u0001\"!\u001b\u0001A\u0003%\u0011QC\u0001\u001a'RkEkX+Q\t\u0006#ViX!Q!2K5)\u0011+J\u001f:\u001b\u0006\u0005C\u0005\u0002n\u0001\u0011\r\u0011\"\u0003\u0002\u0014\u0005\u00113\u000bV'U?\u0016C\u0016j\u0015+T?\u0006su\n\u0016%F%~\u000b\u0005\u000bU0X\u0013RCu\fV%U\u0019\u0016C\u0001\"!\u001d\u0001A\u0003%\u0011QC\u0001$'RkEkX#Y\u0013N#6kX!O\u001fRCUIU0B!B{v+\u0013+I?RKE\u000bT#!\u0011\u001d\t)\b\u0001C\u0001\u0003o\na!\u001e9eCR,G\u0003BA=\u0003\u007f\u00022aEA>\u0013\r\ti\b\u0006\u0002\b\u0005>|G.Z1o\u0011!\t\u0019&a\u001dA\u0002\u0005U\u0003\"CAB\u0001\t\u0007I\u0011BA\n\u0003y\u0019F+\u0014+`\t\u0016cU\tV#`\u0003B\u0003F*S\"B)&{ejU0C3~KE\t\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BA\u000b\u0003}\u0019F+\u0014+`\t\u0016cU\tV#`\u0003B\u0003F*S\"B)&{ejU0C3~KE\t\t\u0005\b\u0003\u0017\u0003A\u0011AAG\u0003\u0019!W\r\\3uKR!\u0011qRAN!\u0019\t\t*a&\u0002z5\u0011\u00111\u0013\u0006\u0004\u0003+#\u0012\u0001B;uS2LA!!'\u0002\u0014\n\u0019AK]=\t\u0011\u0005u\u0015\u0011\u0012a\u0001\u0003o\tQ\"\u00199qY&\u001c\u0017\r^5p]&#\u0007bBAQ\u0001\u0011\u0005\u00111U\u0001\tM&tGMQ=JIR!\u0011QUAV!\u0015\u0019\u0012qUA+\u0013\r\tI\u000b\u0006\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005u\u0015q\u0014a\u0001\u0003oAq!a,\u0001\t\u0003\t\t,A\u0006gS:$W+\u001b3Cs&#G\u0003BAZ\u0003\u0007\u0004RaEAT\u0003k\u0003B!a.\u0002>:!\u00111HA]\u0013\r\tYLG\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty,!1\u0003\u000b\rKW+\u001b3\u000b\u0007\u0005m&\u0004\u0003\u0005\u0002\u001e\u00065\u0006\u0019AA\u001c\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013\fAbZ3u+&$7OQ=JIN$B!a3\u0002RBA\u0011qCAg\u0003o\t),\u0003\u0003\u0002P\u0006\r\"aA'ba\"A\u00111[Ac\u0001\u0004\t).\u0001\bbaBd\u0017nY1uS>t\u0017\nZ:\u0011\r\u0005]\u0017q\\A\u001c\u001d\u0011\tI.!8\u000f\u0007i\nY.C\u0001\u0016\u0013\r\tY\fF\u0005\u0005\u0003C\f\u0019O\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tY\f\u0006\u0005\b\u0003O\u0004A\u0011AAu\u0003\u0019\u0019X-\u0019:dQR!\u00111^Ay!\u0019\t9.!<\u0002V%!\u0011q^Ar\u0005\r\u0019V-\u001d\u0005\t\u0003g\f)\u000f1\u0001\u0002v\u0006\t2/\u001d7XSRD\u0007+\u0019:b[\u0016$XM]:\u0011\t\u0005]\u00181 \b\u0004k\u0005e\u0018bAA^\r&!\u0011Q`A\u0000\u0005E\u0019\u0016\u000f\\,ji\"\u0004\u0016M]1nKR,'o\u001d\u0006\u0004\u0003w3\u0005b\u0002B\u0002\u0001\u0011%!QA\u0001\u0013O\u0016$XI\u001c<je>tW.\u001a8u+&$7\u000f\u0006\u0003\u0002L\n\u001d\u0001\u0002CA*\u0005\u0003\u0001\r!!\u0016\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e\u0005A\u0012N\\:feR\f\u0005\u000f\u001d+p\u000b:4(+\u001a4fe\u0016t7-Z:\u0015\r\t=!Q\u0003B\r!\r\u0019\"\u0011C\u0005\u0004\u0005'!\"\u0001B+oSRD\u0001Ba\u0006\u0003\n\u0001\u0007\u0011QW\u0001\u000fCB\u0004H.[2bi&|g.V5e\u0011!\u0011YB!\u0003A\u0002\tu\u0011aB3omVKGm\u001d\t\u0007\u0003/\u0011y\"!.\n\t\t\u0005\u00121\u0005\u0002\u0004'\u0016$\bb\u0002B\u0013\u0001\u0011%!qE\u0001\u0019kB$\u0017\r^3BaB$v.\u00128w%\u00164WM]3oG\u0016\u001cHC\u0002B\b\u0005S\u0011Y\u0003\u0003\u0005\u0002T\t\r\u0002\u0019AA+\u0011!\u00119Ba\tA\u0002\u0005U\u0006b\u0002B\u0018\u0001\u0011%!\u0011G\u0001\u0019g\u0006t\u0017\u000e^5{K\u0006\u0003\b\u000f\\5dCRLwN\\%oaV$H\u0003\u0002B\b\u0005gA\u0001\"a\u0015\u0003.\u0001\u0007\u0011Q\u000b\u0015\u0004\u0001\t]\u0002\u0003\u0002B\u001d\u0005\u007fi!Aa\u000f\u000b\u0007\tub)A\u0006ue\u0006t7/Y2uS>t\u0017\u0002\u0002B!\u0005w\u0011q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c\u0015\u0004\u0001\t\u0015\u0003\u0003\u0002B$\u0005\u001bj!A!\u0013\u000b\u0007\t-\u0003&\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAAa\u0014\u0003J\tQ!+\u001a9pg&$xN]=)\r\u0001\u0011\u0019&\u001fB1!\u0011\u0011)F!\u0018\u000e\u0005\t]#b\u0001:\u0003Z)\u0019!1\f\u0015\u0002\u000f\r|g\u000e^3yi&!!q\fB,\u0005\u001d\u0001&o\u001c4jY\u0016d#Aa\u0019\"\u0003\u0015\u0001")
public class ApplicationPersistence
implements PersistenceSupport {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final CiIdService ciIdService;
    private final EnvironmentPersistence environmentPersistence;
    private final SecurablePersistence securablePersistence;
    private final String STMT_INSERT_APPLICATIONS;
    private final String STMT_EXISTS_BY_TITLE_IGNORECASE;
    private final String STMT_UPDATE_APPLICATIONS;
    private final String STMT_EXISTS_ANOTHER_APP_WITH_TITLE;
    private final String STMT_DELETE_APPLICATIONS_BY_ID;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, Map<String, Object> params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, Map<String, Object> params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        ApplicationPersistence applicationPersistence = this;
        synchronized (applicationPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        return !this.bitmap$0 ? this.namedTemplate$lzycompute() : this.namedTemplate;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public EnvironmentPersistence environmentPersistence() {
        return this.environmentPersistence;
    }

    public SecurablePersistence securablePersistence() {
        return this.securablePersistence;
    }

    private String STMT_INSERT_APPLICATIONS() {
        return this.STMT_INSERT_APPLICATIONS;
    }

    private String STMT_EXISTS_BY_TITLE_IGNORECASE() {
        return this.STMT_EXISTS_BY_TITLE_IGNORECASE;
    }

    public String insert(Application application) {
        this.sanitizeApplicationInput(application);
        boolean exists = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_BY_TITLE_IGNORECASE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)application.getTitle())})), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$insert$1(x$1))).head());
        if (exists) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Application with title '", "' already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{application.getTitle()})));
        }
        Map<String, Integer> environmentUids = this.getEnvironmentUids(application);
        Integer ciUid = this.securablePersistence().insert();
        String appId = package$.MODULE$.createPersistedId(ClassTag$.MODULE$.apply(Application.class), this.ciIdService());
        String displayedAppId = package$.MODULE$.toDisplayId(appId);
        try {
            this.sqlExec(this.STMT_INSERT_APPLICATIONS(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)ciUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)appId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle())})), x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute()));
        }
        catch (DuplicateKeyException ex) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Application with ID '", "' already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{displayedAppId})), ex);
        }
        this.insertAppToEnvReferences(ciUid, (Set<Integer>)environmentUids.valuesIterator().toSet());
        return displayedAppId;
    }

    private String STMT_UPDATE_APPLICATIONS() {
        return this.STMT_UPDATE_APPLICATIONS;
    }

    private String STMT_EXISTS_ANOTHER_APP_WITH_TITLE() {
        return this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE;
    }

    public boolean update(Application application) {
        Integer applicationUid = (Integer)this.findUidById(application.getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Application [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{application.getId()})), new Object[0]);
        });
        this.sanitizeApplicationInput(application);
        boolean existsAnotherWithSameTitle = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)applicationUid)})), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$update$2(x$3))).head());
        if (existsAnotherWithSameTitle) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Application with title '", "' already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{application.getTitle()})));
        }
        this.updateAppToEnvReferences(application, applicationUid);
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(this.STMT_UPDATE_APPLICATIONS(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)applicationUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle())})), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 == 1));
    }

    private String STMT_DELETE_APPLICATIONS_BY_ID() {
        return this.STMT_DELETE_APPLICATIONS_BY_ID;
    }

    public Try<Object> delete(String applicationId) {
        return (Try)this.sqlExec(this.STMT_DELETE_APPLICATIONS_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)package$.MODULE$.toPersistedId(applicationId))})), ps -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ps.execute()));
    }

    public Option<Application> findById(String applicationId) {
        Tuple2<String, Seq<Object>> tuple2 = ApplicationSqlBuilder$.MODULE$.apply(ApplicationSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).select().withApplicationId(package$.MODULE$.toPersistedId(applicationId)).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.applicationResultSetExtractor());
    }

    public Option<Integer> findUidById(String applicationId) {
        String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|SELECT ", "\n          |FROM ", "\n          |WHERE ", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID(), ApplicationSchema$APPLICATIONS$.MODULE$.TABLE(), ApplicationSchema$APPLICATIONS$.MODULE$.ID(), ApplicationSchema$APPLICATIONS$.MODULE$.ID()})))).stripMargin();
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)package$.MODULE$.toPersistedId(applicationId))})), (Function1 & Serializable & scala.Serializable)rs -> package.CiUid$.MODULE$.apply(rs.getInt(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()))).headOption();
    }

    public Map<String, Integer> getUidsByIds(Iterable<String> applicationIds) {
        String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|SELECT ", ", ", "\n          |FROM ", "\n          |WHERE ", " IN (:applicationIds)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID(), ApplicationSchema$APPLICATIONS$.MODULE$.ID(), ApplicationSchema$APPLICATIONS$.MODULE$.TABLE(), ApplicationSchema$APPLICATIONS$.MODULE$.ID()})))).stripMargin();
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"applicationIds"), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)applicationIds.map((Function1 & Serializable & scala.Serializable)id -> package$.MODULE$.toPersistedId((String)id), Iterable$.MODULE$.canBuildFrom())).asJava())})), (Function1 & Serializable & scala.Serializable)rs -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.ResultSetExtension((ResultSet)rs).getCiId(ApplicationSchema$APPLICATIONS$.MODULE$.ID())), (Object)package.CiUid$.MODULE$.apply(rs.getInt(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID())))).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Application> search(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Seq)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.applicationSearchResultSetExtractor());
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Integer> getEnvironmentUids(Application application) {
        Map map;
        if (CollectionUtils.isEmpty(application.getEnvironments())) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            void var3_3;
            Map<String, Integer> environmentIdsToUids;
            Set environmentIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(application.getEnvironments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set environmentDiff = (Set)environmentIds.diff((GenSet)(environmentIdsToUids = this.environmentPersistence().getUidsByIds((Iterable<String>)environmentIds)).keySet());
            if (environmentDiff.nonEmpty()) {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Environments [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environmentDiff.mkString(", ")})), new Object[0]);
            }
            map = var3_3;
        }
        return map;
    }

    private void insertAppToEnvReferences(Integer applicationUid, Set<Integer> envUids) {
        String insertAppTpEnvStmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " (\n         |", ",\n         |", "\n         |)\n         |VALUES (\n         |:", ",\n         |:", "\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.TABLE(), ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID(), ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID(), ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID(), ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID()})))).stripMargin();
        this.sqlBatch(insertAppTpEnvStmt, (Set<Map<String, Object>>)((Set)envUids.map((Function1 & Serializable & scala.Serializable)envUid -> Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()), (Object)applicationUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID()), envUid)})), Set$.MODULE$.canBuildFrom())));
    }

    private void updateAppToEnvReferences(Application application, Integer applicationUid) {
        Map<String, Integer> envIdsToUids = this.getEnvironmentUids(application);
        String deleteAppToEnvRefsStmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |DELETE FROM ", "\n         | WHERE\n         | ", " = :", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.TABLE(), ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID(), ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()})))).stripMargin();
        this.sqlExec(deleteAppToEnvRefsStmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()), (Object)applicationUid)})), x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.execute()));
        this.insertAppToEnvReferences(applicationUid, (Set<Integer>)envIdsToUids.valuesIterator().toSet());
    }

    private void sanitizeApplicationInput(Application application) {
        application.setTitle(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(application.getTitle()), ApplicationSchema$.MODULE$.TITLE_LENGTH()));
    }

    public static final /* synthetic */ boolean $anonfun$insert$1(ResultSet x$1) {
        return x$1.getInt(1) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$update$2(ResultSet x$3) {
        return x$3.getInt(1) > 0;
    }

    @Autowired
    public ApplicationPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, CiIdService ciIdService, EnvironmentPersistence environmentPersistence, SecurablePersistence securablePersistence) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.ciIdService = ciIdService;
        this.environmentPersistence = environmentPersistence;
        this.securablePersistence = securablePersistence;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        this.STMT_INSERT_APPLICATIONS = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|INSERT INTO ", "\n        |   ( ", "\n        |   , ", "\n        |   , ", "\n        |   )\n        | VALUES\n        |   ( :", "\n        |   , :", "\n        |   , :", "\n        |   )\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ApplicationSchema$APPLICATIONS$.MODULE$.TABLE(), ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID(), ApplicationSchema$APPLICATIONS$.MODULE$.ID(), ApplicationSchema$APPLICATIONS$.MODULE$.TITLE(), ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID(), ApplicationSchema$APPLICATIONS$.MODULE$.ID(), ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()})))).stripMargin();
        this.STMT_EXISTS_BY_TITLE_IGNORECASE = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT COUNT(*) FROM ", " WHERE LOWER(", ") = LOWER(:", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ApplicationSchema$APPLICATIONS$.MODULE$.TABLE(), ApplicationSchema$APPLICATIONS$.MODULE$.TITLE(), ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()}));
        this.STMT_UPDATE_APPLICATIONS = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|UPDATE ", "\n        | SET\n        |  ", " = :", "\n        | WHERE\n        |  ", " = :", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ApplicationSchema$APPLICATIONS$.MODULE$.TABLE(), ApplicationSchema$APPLICATIONS$.MODULE$.TITLE(), ApplicationSchema$APPLICATIONS$.MODULE$.TITLE(), ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID(), ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()})))).stripMargin();
        this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|SELECT COUNT(*)\n        |FROM ", "\n        |WHERE LOWER(", ") = LOWER(:", ")\n        |AND ", " <> :", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ApplicationSchema$APPLICATIONS$.MODULE$.TABLE(), ApplicationSchema$APPLICATIONS$.MODULE$.TITLE(), ApplicationSchema$APPLICATIONS$.MODULE$.TITLE(), ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID(), ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()})))).stripMargin();
        this.STMT_DELETE_APPLICATIONS_BY_ID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|DELETE FROM ", "\n        | WHERE ", " = :", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ApplicationSchema$APPLICATIONS$.MODULE$.TABLE(), ApplicationSchema$APPLICATIONS$.MODULE$.ID(), ApplicationSchema$APPLICATIONS$.MODULE$.ID()})))).stripMargin();
    }
}

