/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.views;

import com.xebialabs.xlrelease.api.v1.views.BaseApplicationView;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentView;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class EnvironmentReservationView {
    private String id;
    private Date startDate;
    private Date endDate;
    private String note;
    private EnvironmentView environment;
    private List<BaseApplicationView> applications = new ArrayList<BaseApplicationView>();

    public static EnvironmentReservationView fromEnvironmentReservation(EnvironmentReservation reservation) {
        EnvironmentReservationView view = new EnvironmentReservationView();
        view.setId(reservation.getId());
        view.setStartDate(reservation.getStartDate());
        view.setEndDate(reservation.getEndDate());
        view.setNote(reservation.getNote());
        view.setEnvironment(EnvironmentView.fromEnvironment(reservation.getEnvironment()));
        view.applications = reservation.getApplications().stream().map(BaseApplicationView::fromApplication).collect(Collectors.toList());
        return view;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public EnvironmentView getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(EnvironmentView environment) {
        this.environment = environment;
    }

    public List<BaseApplicationView> getApplications() {
        return this.applications;
    }

    public void setApplications(List<BaseApplicationView> applications) {
        this.applications = applications;
    }
}

