/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentCreatedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentDeletedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.EnvironmentRepository;
import com.xebialabs.xlrelease.environments.service.EnvironmentSecurity;
import com.xebialabs.xlrelease.environments.service.EnvironmentStageService;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.service.FolderService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u00015\u0011!#\u00128wSJ|g.\\3oiN+'O^5dK*\u00111\u0001B\u0001\bg\u0016\u0014h/[2f\u0015\t)a!\u0001\u0007f]ZL'o\u001c8nK:$8O\u0003\u0002\b\u0011\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\u0006g24GG\u001b\u0006\u00023\u0005AqM]5{u2,G-\u0003\u0002\u001c-\t9Aj\\4hS:<\u0007\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002+\u0015tg/\u001b:p]6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ssB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005B\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0012!\u0005U)eN^5s_:lWM\u001c;SKB|7/\u001b;pefD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0014K:4\u0018N]8o[\u0016tGoU3dkJLG/\u001f\t\u0003O!j\u0011AA\u0005\u0003S\t\u00111#\u00128wSJ|g.\\3oiN+7-\u001e:jifD\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\fe>dWmU3sm&\u001cW\r\u0005\u0002.e5\taF\u0003\u00020a\u0005A1/Z2ve&$\u0018P\u0003\u00022\u0011\u0005AA-\u001a9m_fLG/\u0003\u00024]\tY!k\u001c7f'\u0016\u0014h/[2f\u0011!)\u0004A!A!\u0002\u00131\u0014!\u00044pY\u0012,'oU3sm&\u001cW\r\u0005\u00028s5\t\u0001H\u0003\u0002\u0004\r%\u0011!\b\u000f\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\t\u0011q\u0002!\u0011!Q\u0001\nu\nq#\u001a8wSJ|g.\\3oiN#\u0018mZ3TKJ4\u0018nY3\u0011\u0005\u001dr\u0014BA \u0003\u0005])eN^5s_:lWM\u001c;Ti\u0006<WmU3sm&\u001cW\r\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0001C\u0003!)g/\u001a8u\u0005V\u001cX#A\"\u0011\u0005\u0011;U\"A#\u000b\u0005\u00193\u0011AB3wK:$8/\u0003\u0002I\u000b\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\t\u0011)\u0003!\u0011!Q\u0001\n\r\u000b\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\t\u000b1\u0003A\u0011A'\u0002\rqJg.\u001b;?)\u001dqu\nU)S'R\u0003\"a\n\u0001\t\u000buY\u0005\u0019\u0001\u0010\t\u000b\u0015Z\u0005\u0019\u0001\u0014\t\u000b-Z\u0005\u0019\u0001\u0017\t\u000bUZ\u0005\u0019\u0001\u001c\t\u000bqZ\u0005\u0019A\u001f\t\u000b\u0005[\u0005\u0019A\")\u0005-3\u0006CA,c\u001b\u0005A&BA-[\u0003)\tgN\\8uCRLwN\u001c\u0006\u00037r\u000bqAZ1di>\u0014\u0018P\u0003\u0002^=\u0006)!-Z1og*\u0011q\fY\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011-A\u0002pe\u001eL!a\u0019-\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B3\u0001\t\u00031\u0017AE:fCJ\u001c\u0007.\u00128wSJ|g.\\3oiN$\"a\u001a<\u0011\u0007!lw.D\u0001j\u0015\tQ7.\u0001\u0003vi&d'\"\u00017\u0002\t)\fg/Y\u0005\u0003]&\u0014A\u0001T5tiB\u0011\u0001\u000f^\u0007\u0002c*\u0011QA\u001d\u0006\u0003g\u001a\ta\u0001Z8nC&t\u0017BA;r\u0005-)eN^5s_:lWM\u001c;\t\u000b]$\u0007\u0019\u0001=\u0002%\u0015tg/\u001b:p]6,g\u000e\u001e$jYR,'o\u001d\t\u0004s\u0006\u0005Q\"\u0001>\u000b\u0005md\u0018A\u00024jYR,'O\u0003\u0002~}\u0006\u0011a/\r\u0006\u0003\u007f\u001a\t1!\u00199j\u0013\r\t\u0019A\u001f\u0002\u0013\u000b:4\u0018N]8o[\u0016tGOR5mi\u0016\u00148\u000fK\u0002e\u0003\u000f\u0001B!!\u0003\u0002\u00165\u0011\u00111\u0002\u0006\u00043\u00065!\u0002BA\b\u0003#\tq!\\3ue&\u001c7OC\u0002\u0002\u0014)\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0003/\tYAA\u0003US6,G\rC\u0004\u0002\u001c\u0001!\t!!\b\u0002'\u0019Lg\u000eZ#om&\u0014xN\\7f]R\u0014\u00150\u00133\u0015\u0007=\fy\u0002\u0003\u0005\u0002\"\u0005e\u0001\u0019AA\u0012\u00035)gN^5s_:lWM\u001c;JIB!\u0011QEA\u001a\u001d\u0011\t9#a\f\u0011\u0007\u0005%\u0002#\u0004\u0002\u0002,)\u0019\u0011Q\u0006\u0007\u0002\rq\u0012xn\u001c;?\u0013\r\t\t\u0004E\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0012q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E\u0002\u0003\u000b\u0003\u0002\u001a\u0005\u001d\u0001bBA\u001f\u0001\u0011\u0005\u0011qH\u0001\u0012GJ,\u0017\r^3F]ZL'o\u001c8nK:$HcA8\u0002B!9\u00111IA\u001e\u0001\u0004y\u0017aC3om&\u0014xN\\7f]RDC!a\u000f\u0002\b!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013!E;qI\u0006$X-\u00128wSJ|g.\\3oiR\u0019q.!\u0014\t\u000f\u0005\r\u0013q\ta\u0001_\"\"\u0011qIA\u0004\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\n\u0011\u0003Z3mKR,WI\u001c<je>tW.\u001a8u)\u0011\t9&!\u0018\u0011\u0007=\tI&C\u0002\u0002\\A\u0011A!\u00168ji\"A\u0011\u0011EA)\u0001\u0004\t\u0019\u0003\u000b\u0003\u0002R\u0005\u001d\u0001bBA2\u0001\u0011%\u0011QM\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011qKA4\u0011\u001d\t\u0019%!\u0019A\u0002=Dq!a\u001b\u0001\t\u0013\ti'A\u0007wC2LG-\u0019;f)&$H.\u001a\u000b\u0005\u0003/\ny\u0007C\u0004\u0002D\u0005%\u0004\u0019A8\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v\u0005\u0019b/\u00197jI\u0006$X\rR3tGJL\u0007\u000f^5p]R!\u0011qKA<\u0011\u001d\t\u0019%!\u001dA\u0002=D3\u0001AA>!\u0011\ti(a!\u000e\u0005\u0005}$bAAA=\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005\u0015\u0015q\u0010\u0002\b'\u0016\u0014h/[2f\u0001")
public class EnvironmentService
implements Logging {
    private final EnvironmentRepository environmentRepository;
    private final EnvironmentSecurity environmentSecurity;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentService environmentService = this;
        synchronized (environmentService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public List<Environment> searchEnvironments(EnvironmentFilters environmentFilters) {
        this.environmentSecurity.checkView();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.environmentRepository.searchEnvironments(environmentFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public Environment findEnvironmentById(String environmentId) {
        this.environmentSecurity.checkView();
        return this.environmentRepository.findEnvironmentById(environmentId);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Environment createEnvironment(Environment environment) {
        void var2_2;
        this.environmentSecurity.checkCreate();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Creating a new environment");
        this.validate(environment);
        Environment created = this.environmentRepository.createEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentCreatedEvent(created));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Environment updateEnvironment(Environment environment) {
        void var2_2;
        this.environmentSecurity.checkEdit();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating environment [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environment})));
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environment);
        Environment updated = this.environmentRepository.updateEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentUpdatedEvent(environment));
        return var2_2;
    }

    @Timed
    public void deleteEnvironment(String environmentId) {
        this.environmentSecurity.checkEdit();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting environment [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environmentId})));
        Environment environment = this.environmentRepository.findEnvironmentById(environmentId);
        this.environmentRepository.deleteEnvironment(environmentId);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentDeletedEvent(environment));
    }

    private void validate(Environment environment) {
        this.validateTitle(environment);
        this.validateDescription(environment);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environment.getStage()).exists((Function1 & Serializable & scala.Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)EnvironmentService.$anonfun$validate$1(stage))), (String)"Environment stage ID is required", (Object[])new Object[0]);
    }

    private void validateTitle(Environment environment) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    private void validateDescription(Environment environment) {
        block0: {
            if (environment.getDescription() == null) break block0;
            Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Description cannot be blank", (Object[])new Object[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(EnvironmentStage stage) {
        return StringUtils.hasText((String)stage.getId());
    }

    @Autowired
    public EnvironmentService(EnvironmentRepository environmentRepository, EnvironmentSecurity environmentSecurity, RoleService roleService, FolderService folderService, EnvironmentStageService environmentStageService, XLReleaseEventBus eventBus) {
        this.environmentRepository = environmentRepository;
        this.environmentSecurity = environmentSecurity;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

