/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.environments.repository.EnvironmentRepository;
import com.xebialabs.xlrelease.environments.service.EnvironmentSecurity;
import com.xebialabs.xlrelease.environments.service.EnvironmentStageService;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.service.FolderService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\b\u0011\u0001mA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!)\u0005A!A!\u0002\u00131\u0005\"B%\u0001\t\u0003Q\u0005\"\u00021\u0001\t\u0003\t\u0007bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002P\u0001!I!!\u0015\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u00111\f\u0001\u0005\n\u0005u#AE#om&\u0014xN\\7f]R\u001cVM\u001d<jG\u0016T!!\u0005\n\u0002\u000fM,'O^5dK*\u00111\u0003F\u0001\rK:4\u0018N]8o[\u0016tGo\u001d\u0006\u0003+Y\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005]A\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0012aA2p[\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u000bMdg\r\u000e6\u000b\u0003\u001d\n\u0001b\u001a:jujdW\rZ\u0005\u0003S\u0011\u0012q\u0001T8hO&tw-A\u000bf]ZL'o\u001c8nK:$(+\u001a9pg&$xN]=\u0011\u00051zS\"A\u0017\u000b\u00059\u0012\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0001'\f\u0002\u0016\u000b:4\u0018N]8o[\u0016tGOU3q_NLGo\u001c:z\u0003M)gN^5s_:lWM\u001c;TK\u000e,(/\u001b;z!\t\u0019D'D\u0001\u0011\u0013\t)\u0004CA\nF]ZL'o\u001c8nK:$8+Z2ve&$\u00180A\u0006s_2,7+\u001a:wS\u000e,\u0007C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003!\u0019XmY;sSRL(B\u0001\u001f\u0017\u0003!!W\r\u001d7ps&$\u0018B\u0001 :\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002\u001b\u0019|G\u000eZ3s'\u0016\u0014h/[2f!\t\t5)D\u0001C\u0015\t\tB#\u0003\u0002E\u0005\niai\u001c7eKJ\u001cVM\u001d<jG\u0016\fq#\u001a8wSJ|g.\\3oiN#\u0018mZ3TKJ4\u0018nY3\u0011\u0005M:\u0015B\u0001%\u0011\u0005])eN^5s_:lWM\u001c;Ti\u0006<WmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0007\u00172kej\u0014)\u0011\u0005M\u0002\u0001\"\u0002\u0016\u0007\u0001\u0004Y\u0003\"B\u0019\u0007\u0001\u0004\u0011\u0004\"\u0002\u001c\u0007\u0001\u00049\u0004\"B \u0007\u0001\u0004\u0001\u0005\"B#\u0007\u0001\u00041\u0005F\u0001\u0004S!\t\u0019f,D\u0001U\u0015\t)f+\u0001\u0006b]:|G/\u0019;j_:T!a\u0016-\u0002\u000f\u0019\f7\r^8ss*\u0011\u0011LW\u0001\u0006E\u0016\fgn\u001d\u0006\u00037r\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002;\u0006\u0019qN]4\n\u0005}#&!C!vi><\u0018N]3e\u0003I\u0019X-\u0019:dQ\u0016sg/\u001b:p]6,g\u000e^:\u0015\u0005\t\f\bcA2iU6\tAM\u0003\u0002fM\u0006!Q\u000f^5m\u0015\u00059\u0017\u0001\u00026bm\u0006L!!\u001b3\u0003\t1K7\u000f\u001e\t\u0003W>l\u0011\u0001\u001c\u0006\u0003'5T!A\u001c\u000b\u0002\r\u0011|W.Y5o\u0013\t\u0001HNA\u0006F]ZL'o\u001c8nK:$\b\"\u0002:\b\u0001\u0004\u0019\u0018AE3om&\u0014xN\\7f]R4\u0015\u000e\u001c;feN\u0004\"\u0001^>\u000e\u0003UT!A^<\u0002\r\u0019LG\u000e^3s\u0015\tA\u00180\u0001\u0002wc)\u0011!\u0010F\u0001\u0004CBL\u0017B\u0001?v\u0005I)eN^5s_:lWM\u001c;GS2$XM]:)\u0005\u001dq\bcA@\u0002\f5\u0011\u0011\u0011\u0001\u0006\u0004+\u0006\r!\u0002BA\u0003\u0003\u000f\tq!\\3ue&\u001c7OC\u0002\u0002\na\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0003\u001b\t\tAA\u0003US6,G-A\ngS:$WI\u001c<je>tW.\u001a8u\u0005fLE\rF\u0002k\u0003'Aq!!\u0006\t\u0001\u0004\t9\"A\u0007f]ZL'o\u001c8nK:$\u0018\n\u001a\t\u0005\u00033\t9C\u0004\u0003\u0002\u001c\u0005\r\u0002cAA\u000f=5\u0011\u0011q\u0004\u0006\u0004\u0003CQ\u0012A\u0002\u001fs_>$h(C\u0002\u0002&y\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0015\u0003W\u0011aa\u0015;sS:<'bAA\u0013=!\u0012\u0001B`\u0001\u0012GJ,\u0017\r^3F]ZL'o\u001c8nK:$Hc\u00016\u00024!1\u0011QG\u0005A\u0002)\f1\"\u001a8wSJ|g.\\3oi\"\u0012\u0011B`\u0001\u0012kB$\u0017\r^3F]ZL'o\u001c8nK:$Hc\u00016\u0002>!1\u0011Q\u0007\u0006A\u0002)D#A\u0003@\u0002#\u0011,G.\u001a;f\u000b:4\u0018N]8o[\u0016tG\u000f\u0006\u0003\u0002F\u0005-\u0003cA\u000f\u0002H%\u0019\u0011\u0011\n\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003+Y\u0001\u0019AA\fQ\tYa0\u0001\u0005wC2LG-\u0019;f)\u0011\t)%a\u0015\t\r\u0005UB\u00021\u0001k\u000351\u0018\r\\5eCR,G+\u001b;mKR!\u0011QIA-\u0011\u0019\t)$\u0004a\u0001U\u0006\u0019b/\u00197jI\u0006$X\rR3tGJL\u0007\u000f^5p]R!\u0011QIA0\u0011\u0019\t)D\u0004a\u0001U\"\u001a\u0001!a\u0019\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003OR1!!\u001b[\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003[\n9GA\u0004TKJ4\u0018nY3")
public class EnvironmentService
implements Logging {
    private final EnvironmentRepository environmentRepository;
    private final EnvironmentSecurity environmentSecurity;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentService environmentService = this;
        synchronized (environmentService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public List<Environment> searchEnvironments(EnvironmentFilters environmentFilters) {
        this.environmentSecurity.checkView();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.environmentRepository.searchEnvironments(environmentFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public Environment findEnvironmentById(String environmentId) {
        this.environmentSecurity.checkView();
        return this.environmentRepository.findEnvironmentById(environmentId);
    }

    @Timed
    public Environment createEnvironment(Environment environment) {
        this.environmentSecurity.checkCreate();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Creating a new environment");
        this.validate(environment);
        return this.environmentRepository.createEnvironment(environment);
    }

    @Timed
    public Environment updateEnvironment(Environment environment) {
        this.environmentSecurity.checkEdit();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Updating environment [").append((Object)environment).append("]").toString());
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environment);
        return this.environmentRepository.updateEnvironment(environment);
    }

    @Timed
    public void deleteEnvironment(String environmentId) {
        this.environmentSecurity.checkEdit();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Deleting environment [").append(environmentId).append("]").toString());
        this.environmentRepository.deleteEnvironment(environmentId);
    }

    private void validate(Environment environment) {
        this.validateTitle(environment);
        this.validateDescription(environment);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environment.getStage()).exists((Function1 & Serializable & scala.Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)EnvironmentService.$anonfun$validate$1(stage))), (String)"Environment stage ID is required", (Object[])new Object[0]);
    }

    private void validateTitle(Environment environment) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    private void validateDescription(Environment environment) {
        block0: {
            if (environment.getDescription() == null) break block0;
            Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Description cannot be blank", (Object[])new Object[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(EnvironmentStage stage) {
        return StringUtils.hasText((String)stage.getId());
    }

    @Autowired
    public EnvironmentService(EnvironmentRepository environmentRepository, EnvironmentSecurity environmentSecurity, RoleService roleService, FolderService folderService, EnvironmentStageService environmentStageService) {
        this.environmentRepository = environmentRepository;
        this.environmentSecurity = environmentSecurity;
        Logging.$init$((Logging)this);
    }
}

