/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository;
import com.xebialabs.xlrelease.environments.service.ApplicationSecurity;
import com.xebialabs.xlrelease.environments.service.package$;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0006\r\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)!\u0006\u0001C\u0001W!)a\b\u0001C\u0001\u007f!)Q\r\u0001C\u0001M\")Q\u000f\u0001C\u0001m\")!\u0010\u0001C\u0001w\")a\u0010\u0001C\u0001\u007f\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\u000b\u0001\u0011%\u0011q\u0003\u0002\u0013\u0003B\u0004H.[2bi&|gnU3sm&\u001cWM\u0003\u0002\u000e\u001d\u000591/\u001a:wS\u000e,'BA\b\u0011\u00031)gN^5s_:lWM\u001c;t\u0015\t\t\"#A\u0005yYJ,G.Z1tK*\u00111\u0003F\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!F\u0001\u0004G>l7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017!F1qa2L7-\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003A\rj\u0011!\t\u0006\u0003E9\t!B]3q_NLGo\u001c:z\u0013\t!\u0013EA\u000bBaBd\u0017nY1uS>t'+\u001a9pg&$xN]=\u0002'\u0005\u0004\b\u000f\\5dCRLwN\\*fGV\u0014\u0018\u000e^=\u0011\u0005\u001dBS\"\u0001\u0007\n\u0005%b!aE!qa2L7-\u0019;j_:\u001cVmY;sSRL\u0018A\u0002\u001fj]&$h\bF\u0002-[9\u0002\"a\n\u0001\t\u000by\u0019\u0001\u0019A\u0010\t\u000b\u0015\u001a\u0001\u0019\u0001\u0014)\u0005\r\u0001\u0004CA\u0019=\u001b\u0005\u0011$BA\u001a5\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003kY\nqAZ1di>\u0014\u0018P\u0003\u00028q\u0005)!-Z1og*\u0011\u0011HO\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t1(A\u0002pe\u001eL!!\u0010\u001a\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AE:fCJ\u001c\u0007.\u00119qY&\u001c\u0017\r^5p]N$\"\u0001Q(\u0011\u0007\u00053\u0005*D\u0001C\u0015\t\u0019E)\u0001\u0003vi&d'\"A#\u0002\t)\fg/Y\u0005\u0003\u000f\n\u0013A\u0001T5tiB\u0011\u0011*T\u0007\u0002\u0015*\u0011qb\u0013\u0006\u0003\u0019B\ta\u0001Z8nC&t\u0017B\u0001(K\u0005-\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\t\u000bA#\u0001\u0019A)\u0002%\u0005\u0004\b\u000f\\5dCRLwN\u001c$jYR,'o\u001d\t\u0003%fk\u0011a\u0015\u0006\u0003)V\u000baAZ5mi\u0016\u0014(B\u0001,X\u0003\t1\u0018G\u0003\u0002Y!\u0005\u0019\u0011\r]5\n\u0005i\u001b&AE!qa2L7-\u0019;j_:4\u0015\u000e\u001c;feND#\u0001\u0002/\u0011\u0005u\u001bW\"\u00010\u000b\u0005Mz&B\u00011b\u0003\u001diW\r\u001e:jGNT!A\u0019\u000b\u0002\u0011\r|G-\u00195bY\u0016L!\u0001\u001a0\u0003\u000bQKW.\u001a3\u0002'\u0019Lg\u000eZ!qa2L7-\u0019;j_:\u0014\u00150\u00133\u0015\u0005!;\u0007\"\u00025\u0006\u0001\u0004I\u0017!D1qa2L7-\u0019;j_:LE\r\u0005\u0002kc:\u00111n\u001c\t\u0003Yji\u0011!\u001c\u0006\u0003]Z\ta\u0001\u0010:p_Rt\u0014B\u00019\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005AT\u0002FA\u0003]\u0003E\u0019'/Z1uK\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0003\u0011^DQ\u0001\u001f\u0004A\u0002!\u000b1\"\u00199qY&\u001c\u0017\r^5p]\"\u0012a\u0001X\u0001\u0012kB$\u0017\r^3BaBd\u0017nY1uS>tGC\u0001%}\u0011\u0015Ax\u00011\u0001IQ\t9A,A\teK2,G/Z!qa2L7-\u0019;j_:$B!!\u0001\u0002\bA\u0019\u0011$a\u0001\n\u0007\u0005\u0015!D\u0001\u0003V]&$\b\"\u00025\t\u0001\u0004I\u0007F\u0001\u0005]\u0003\u0019:W\r^!qa2L7-\u0019;j_:\u001cH)\u001a9m_f\f'\r\\3P]\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0004\u0001\u0006=\u0001BBA\t\u0013\u0001\u0007\u0011.A\u0007f]ZL'o\u001c8nK:$\u0018\n\u001a\u0015\u0003\u0013q\u000bQB^1mS\u0012\fG/\u001a+ji2,G\u0003BA\u0001\u00033AQ\u0001\u001f\u0006A\u0002!C3\u0001AA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012q\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005\u001d\u0012\u0011\u0005\u0002\b'\u0016\u0014h/[2f\u0001")
public class ApplicationService {
    private final ApplicationRepository applicationRepository;
    private final ApplicationSecurity applicationSecurity;

    @Timed
    public List<Application> searchApplications(ApplicationFilters applicationFilters) {
        this.applicationSecurity.checkView();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.applicationRepository.searchApplications(applicationFilters, package$.MODULE$.defaultPage())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application findApplicationById(String applicationId) {
        void var2_2;
        this.applicationSecurity.checkView();
        Application application = this.applicationRepository.findApplicationById(applicationId);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application createApplication(Application application) {
        void var2_2;
        this.applicationSecurity.checkCreate();
        this.validateTitle(application);
        Application createdApplication = this.applicationRepository.createApplication(application);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application updateApplication(Application application) {
        void var2_2;
        this.applicationSecurity.checkEdit();
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validateTitle(application);
        Application updatedApplication = this.applicationRepository.updateApplication(application);
        return var2_2;
    }

    @Timed
    public void deleteApplication(String applicationId) {
        this.applicationSecurity.checkEdit();
        this.applicationRepository.deleteApplication(applicationId);
    }

    @Timed
    public List<Application> getApplicationsDeployableOnEnvironment(String environmentId) {
        this.applicationSecurity.checkView();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.applicationRepository.getApplicationsDeployableOnEnvironment(environmentId)).asJava();
    }

    private void validateTitle(Application application) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    @Autowired
    public ApplicationService(ApplicationRepository applicationRepository, ApplicationSecurity applicationSecurity) {
        this.applicationRepository = applicationRepository;
        this.applicationSecurity = applicationSecurity;
    }
}

