/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository;
import com.xebialabs.xlrelease.environments.service.ApplicationSecurity;
import com.xebialabs.xlrelease.environments.service.package$;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u00015\u0011!#\u00119qY&\u001c\u0017\r^5p]N+'O^5dK*\u00111\u0001B\u0001\bg\u0016\u0014h/[2f\u0015\t)a!\u0001\u0007f]ZL'o\u001c8nK:$8O\u0003\u0002\b\u0011\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012!F1qa2L7-\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\t!B]3q_NLGo\u001c:z\u0013\tY\u0002DA\u000bBaBd\u0017nY1uS>t'+\u001a9pg&$xN]=\t\u0011u\u0001!\u0011!Q\u0001\ny\t1#\u00199qY&\u001c\u0017\r^5p]N+7-\u001e:jif\u0004\"a\b\u0011\u000e\u0003\tI!!\t\u0002\u0003'\u0005\u0003\b\u000f\\5dCRLwN\\*fGV\u0014\u0018\u000e^=\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\r)ce\n\t\u0003?\u0001AQ!\u0006\u0012A\u0002YAQ!\b\u0012A\u0002yA#AI\u0015\u0011\u0005)*T\"A\u0016\u000b\u00051j\u0013AC1o]>$\u0018\r^5p]*\u0011afL\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u0001\u0014'A\u0003cK\u0006t7O\u0003\u00023g\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u00015\u0003\ry'oZ\u0005\u0003m-\u0012\u0011\"Q;u_^L'/\u001a3\t\u000ba\u0002A\u0011A\u001d\u0002%M,\u0017M]2i\u0003B\u0004H.[2bi&|gn\u001d\u000b\u0003u%\u00032a\u000f!C\u001b\u0005a$BA\u001f?\u0003\u0011)H/\u001b7\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u0010\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002D\u000f6\tAI\u0003\u0002\u0006\u000b*\u0011aIB\u0001\u0007I>l\u0017-\u001b8\n\u0005!#%aC!qa2L7-\u0019;j_:DQAS\u001cA\u0002-\u000b!#\u00199qY&\u001c\u0017\r^5p]\u001aKG\u000e^3sgB\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\u0007M&dG/\u001a:\u000b\u0005A\u000b\u0016A\u0001<2\u0015\t\u0011f!A\u0002ba&L!\u0001V'\u0003%\u0005\u0003\b\u000f\\5dCRLwN\u001c$jYR,'o\u001d\u0015\u0003oY\u0003\"aV/\u000e\u0003aS!\u0001L-\u000b\u0005i[\u0016aB7fiJL7m\u001d\u0006\u00039*\t\u0001bY8eC\"\fG.Z\u0005\u0003=b\u0013Q\u0001V5nK\u0012DQ\u0001\u0019\u0001\u0005\u0002\u0005\f1CZ5oI\u0006\u0003\b\u000f\\5dCRLwN\u001c\"z\u0013\u0012$\"A\u00112\t\u000b\r|\u0006\u0019\u00013\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e!\t)GN\u0004\u0002gUB\u0011q\rE\u0007\u0002Q*\u0011\u0011\u000eD\u0001\u0007yI|w\u000e\u001e \n\u0005-\u0004\u0012A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a\u001b\t)\u0005}3\u0006\"B9\u0001\t\u0003\u0011\u0018!E2sK\u0006$X-\u00119qY&\u001c\u0017\r^5p]R\u0011!i\u001d\u0005\u0006iB\u0004\rAQ\u0001\fCB\u0004H.[2bi&|g\u000e\u000b\u0002q-\")q\u000f\u0001C\u0001q\u0006\tR\u000f\u001d3bi\u0016\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\u0015\u0005\tK\b\"\u0002;w\u0001\u0004\u0011\u0005F\u0001<W\u0011\u0015a\b\u0001\"\u0001~\u0003E!W\r\\3uK\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0004}\u0006\r\u0001CA\b\u0000\u0013\r\t\t\u0001\u0005\u0002\u0005+:LG\u000fC\u0003dw\u0002\u0007A\r\u000b\u0002|-\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011AJ4fi\u0006\u0003\b\u000f\\5dCRLwN\\:EKBdw._1cY\u0016|e.\u00128wSJ|g.\\3oiR\u0019!(!\u0004\t\u000f\u0005=\u0011q\u0001a\u0001I\u0006iQM\u001c<je>tW.\u001a8u\u0013\u0012D3!a\u0002W\u0011\u001d\t)\u0002\u0001C\u0005\u0003/\tQB^1mS\u0012\fG/\u001a+ji2,Gc\u0001@\u0002\u001a!1A/a\u0005A\u0002\tC3\u0001AA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012c\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005\u001d\u0012\u0011\u0005\u0002\b'\u0016\u0014h/[2f\u0001")
public class ApplicationService {
    private final ApplicationRepository applicationRepository;
    private final ApplicationSecurity applicationSecurity;

    @Timed
    public List<Application> searchApplications(ApplicationFilters applicationFilters) {
        this.applicationSecurity.checkView();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.applicationRepository.searchApplications(applicationFilters, package$.MODULE$.defaultPage())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application findApplicationById(String applicationId) {
        void var2_2;
        this.applicationSecurity.checkView();
        Application application = this.applicationRepository.findApplicationById(applicationId);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application createApplication(Application application) {
        void var2_2;
        this.applicationSecurity.checkCreate();
        this.validateTitle(application);
        Application createdApplication = this.applicationRepository.createApplication(application);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Application updateApplication(Application application) {
        void var2_2;
        this.applicationSecurity.checkEdit();
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validateTitle(application);
        Application updatedApplication = this.applicationRepository.updateApplication(application);
        return var2_2;
    }

    @Timed
    public void deleteApplication(String applicationId) {
        this.applicationSecurity.checkEdit();
        this.applicationRepository.deleteApplication(applicationId);
    }

    @Timed
    public List<Application> getApplicationsDeployableOnEnvironment(String environmentId) {
        this.applicationSecurity.checkView();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.applicationRepository.getApplicationsDeployableOnEnvironment(environmentId)).asJava();
    }

    private void validateTitle(Application application) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    @Autowired
    public ApplicationService(ApplicationRepository applicationRepository, ApplicationSecurity applicationSecurity) {
        this.applicationRepository = applicationRepository;
        this.applicationSecurity = applicationSecurity;
    }
}

