import noop from 'lodash/noop';
import { Label, LabelsState } from '../../../application-list.types';
import { PayloadAction, createSlice } from '@reduxjs/toolkit';

export const initialState: LabelsState = {
    labelList: [],
};

export const labelsState = createSlice({
    name: 'labelsState',
    initialState,
    reducers: {
        searchLabels: (_state: LabelsState, _action: PayloadAction<string>) => noop(),
        setLabels: (state: LabelsState, action: PayloadAction<Array<Label>>) => {
            state.labelList = action.payload;
        },
        saveLabel: (_state: LabelsState, _action: PayloadAction<Label>) => noop(),
        deleteLabel: (_state: LabelsState, _action: PayloadAction<Label>) => noop(),
    },
});
