package com.xebialabs.xlrelease.environments.repository.sql.persistence.data

import com.xebialabs.xlrelease.environments.repository.sql.persistence.ResultSetExtension
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ColumnAliases
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport
import org.springframework.jdbc.core.ResultSetExtractor

import scala.collection.mutable

sealed case class ApplicationSearchResultRow(
                                              override val id: CiId,
                                              override val folderId: String,
                                              override val json: String)
  extends RowWithContent

object ApplicationSearchResultRow extends CompressionSupport {
  private sealed case class ApplicationSearchRow(folderId: String, appJson: String)

  def applicationSearchResultSetExtractor(): ResultSetExtractor[Vector[ApplicationSearchResultRow]] = rs => {
    val appMap: mutable.Map[String, ApplicationSearchRow] = mutable.Map.empty
    while (rs.next()) {
      val appId = rs.getCiId(ColumnAliases.Applications.ID)
      val folderId = buildFolderId(rs, ColumnAliases.Applications.FOLDER_ID, ColumnAliases.Applications.FOLDER_PATH)
      appMap.getOrElseUpdate(appId, ApplicationSearchRow(
        folderId,
        getContent(rs, ColumnAliases.Applications.CONTENT)
      ))
    }

    appMap.view.map { case (appId, app) =>
      ApplicationSearchResultRow(
        appId,
        app.folderId,
        app.appJson
      )
    }.toVector
  }
}

