package com.xebialabs.xlrelease.environments.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.domain.environments.Environment
import com.xebialabs.xlrelease.environments.repository.EnvironmentRepository
import com.xebialabs.xlrelease.limits.LimitEnforcer
import com.xebialabs.xlrelease.limits.LimitEnforcer.LimitType
import com.xebialabs.xlrelease.repository.PersistenceInterceptor
import com.xebialabs.xlrelease.utils.TenantContext
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component
import org.springframework.util.StringUtils.hasText

@Component
@IsTransactional
class EnvironmentLimitPersistenceInterceptor(limitEnforcer: LimitEnforcer,
                                             environmentRepository: EnvironmentRepository)
  extends PersistenceInterceptor[Environment] with Logging {

  environmentRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: Environment): Unit = {
    val tenantId = ensureTenantId(ci)
    limitEnforcer.enforceLimit(tenantId, LimitType.ENVIRONMENTS, 1, () => environmentRepository.tenantEnvironmentCount(tenantId))
  }

  private def ensureTenantId(ci: Environment): String = {
    if (hasText(ci.getTenantId)) {
      // case when environment is auto-created by system via live deployments
      ci.getTenantId
    } else {
      val tenantIdFromContext = TenantContext.getTenant()
      ci.setTenantId(tenantIdFromContext)
      tenantIdFromContext
    }
  }
}
