package com.xebialabs.xlrelease.environments.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.domain.environments.Application
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository
import com.xebialabs.xlrelease.limits.LimitEnforcer
import com.xebialabs.xlrelease.limits.LimitEnforcer.LimitType
import com.xebialabs.xlrelease.repository.PersistenceInterceptor
import com.xebialabs.xlrelease.utils.TenantContext
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component
import org.springframework.util.StringUtils.hasText

@Component
@IsTransactional
class ApplicationLimitPersistenceInterceptor(limitEnforcer: LimitEnforcer,
                                             applicationRepository: ApplicationRepository)
  extends PersistenceInterceptor[Application] with Logging {

  applicationRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: Application): Unit = {
    val tenantId = ensureTenantId(ci)
    limitEnforcer.enforceLimit(tenantId, LimitType.APPLICATIONS, 1, () => applicationRepository.tenantApplicationCount(tenantId))
  }

  private def ensureTenantId(ci: Application): String = {
    if (hasText(ci.getTenantId)) {
      // case when application is auto-created by system via live deployments
      ci.getTenantId
    } else {
      val tenantIdFromContext = TenantContext.getTenant()
      ci.setTenantId(tenantIdFromContext)
      tenantIdFromContext
    }
  }
}
