package com.xebialabs.xlrelease.domain.tasks;

import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.Task;

import static com.google.common.base.Preconditions.checkArgument;

@Component
public class DeploymentFacetTaskUpdateValidator implements TaskUpdateValidator {

    protected static final String UDM_DEPLOYMENT_TASK_FACET = "udm.DeploymentTaskFacet";

    @Override
    public void checkTask(Task oldTask, Task newTask) {
        if (oldTask.isCheckAttributes() != newTask.isCheckAttributes() && newTask.isCheckAttributes()) {
            checkArgument(oldTask.getFacets().stream().anyMatch(f -> f != null && UDM_DEPLOYMENT_TASK_FACET.equals(f.getType().toString())),
                    "Can't set to check environment if there is no deployment facet");
        }
    }
}
