import React from 'react';
import { EnvironmentEditHeaderComponent } from './environment-edit-header-component';
import './environment-edit-page-component.less';
import { EnvironmentFormComponent } from './environment-form-component';
import { DotThemeProvider } from '@digital-ai/dot-components';

export interface EnvironmentEditPageProps {
    environmentId: string;
    folderId: string;
}

export const EnvironmentEditPageComponent = ({ environmentId, folderId }: EnvironmentEditPageProps) => {
    return (
        <div className="environment-edit-page">
            <DotThemeProvider>
                <EnvironmentEditHeaderComponent environmentId={environmentId} folderId={folderId} />
                <EnvironmentFormComponent environmentId={environmentId} folderId={folderId} />
            </DotThemeProvider>
        </div>
    );
};
