import React from 'react';
import { ApplicationEditHeaderComponent } from './application-edit-header-component';
import { mountWithTheme, preparePortalContainer, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';

describe('Application edit header component', () => {
    let wrapper: ReactWrapper;
    const saveCaption = 'Create';
    const saveEnabled = true;
    const onSave = jest.fn();
    const onCancel = jest.fn();

    const mount = () => {
        wrapper = mountWithTheme(<ApplicationEditHeaderComponent {...{ saveCaption, saveEnabled, onSave, onCancel }} />);
    };

    beforeEach(() => {
        preparePortalContainer();
        mount();
    });

    it('should create default state', () => {
        const portal = wrapper.find('ActionToolbarPortalContainer');
        expect(portal.prop('helpLink')).toBe('how-to/using-applications');

        const saveButton = wrapper.find('ActionToolbarPortalContainer button').at(1);
        expect(saveButton.text()).toBe(saveCaption);
        expect(saveButton.props().disabled).toBe(!saveEnabled);
    });

    it('should handle properly callbacks', () => {
        const cancelButton = wrapper.find('ActionToolbarPortalContainer button').first();
        expect(cancelButton.exists()).toBeTruthy();
        cancelButton.simulate('click');
        expect(onCancel).toHaveBeenCalledTimes(1);

        const saveButton = wrapper.find('ActionToolbarPortalContainer button').at(1);
        saveButton.simulate('click');
        expect(onSave).toHaveBeenCalledTimes(1);
    });
});
