package com.xebialabs.xlrelease.environments.repository.sql.persistence.builder

import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.db.sql.{SqlBuilder, SqlWithParameters}
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentStageSchema.ENV_STAGES

class EnvironmentStageSqlBuilder(implicit dialect: Dialect) extends SqlBuilder[EnvironmentStageSqlBuilder] {
  val envStageAlias = "envStage"

  private val STMT_SELECT_ENV_STAGE =
    s"""
       |SELECT
       |  $envStageAlias.${ENV_STAGES.ID} ${ENV_STAGES.ID},
       |  $envStageAlias.${ENV_STAGES.TITLE} ${ENV_STAGES.TITLE}
       |FROM ${ENV_STAGES.TABLE} $envStageAlias
       |""".stripMargin

  override def build(): SqlWithParameters = {
    super.build()
  }

  def select(): EnvironmentStageSqlBuilder = {
    super.select(STMT_SELECT_ENV_STAGE)
  }

  def withTitleLike(title: String): EnvironmentStageSqlBuilder = {
    like(s"$envStageAlias.${ENV_STAGES.TITLE}", title)
  }

  override def newInstance: EnvironmentStageSqlBuilder = new EnvironmentStageSqlBuilder()

}
