import { applicationLists, initialState } from './application-list.reducer';
import { application, stateWithApplications } from '../__mocks__/application-list.mocks';

const { setApplicationToDelete, editApplication, createApplication, setApplications, searchApplications, deleteApplication } = applicationLists.actions;

describe('Application list reducer', () => {
    it('should have the initial state', () => {
        expect(applicationLists.name).toBe('applicationLists');
        expect(applicationLists.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    it('should set applications', () => {
        const applications = [
            {
                id: 'Application1',
                title: 'Application1',
                folderId: '',
                environments: [],
            },
        ];
        const state = applicationLists.reducer(initialState, setApplications(applications));
        expect(state.applications).toMatchObject(applications);
    });

    it('should not deal with state when deleteApplication', () => {
        const state = applicationLists.reducer(stateWithApplications, deleteApplication(stateWithApplications.applications[0]));
        expect(state.applications).toHaveLength(3);
        expect(state.applications).toStrictEqual(stateWithApplications.applications);
    });

    it('should not deal with state when createApplication', () => {
        const state = applicationLists.reducer(initialState, createApplication('someId'));
        expect(state.applications).toMatchObject(initialState.applications);
    });

    it('should not deal with state when searchApplications', () => {
        const state = applicationLists.reducer(initialState, searchApplications({ folderId: '', title: '' }));
        expect(state.applications).toMatchObject(initialState.applications);
    });

    it('should not deal with state when editApplication', () => {
        const state = applicationLists.reducer(stateWithApplications, editApplication({ folderId: '', appId: 'Application3' }));
        expect(state.applications).toMatchObject(stateWithApplications.applications);
    });

    it('should setApplicationToDelete', () => {
        const state = applicationLists.reducer(initialState, setApplicationToDelete(application));
        expect(state.applicationToDelete).toStrictEqual(application);
    });
});
