import React from 'react';
import { ReactWrapper } from 'enzyme';
import { EnvironmentEditHeaderComponent } from './environment-edit-header-component';
import { mountComponentWithStore, preparePortalContainer } from '@xlr-ui/tests/unit/testing-utils';
import { RootState } from '@xlr-ui/app/js/store.types';
import { environmentForm } from '../ducks/environment-form.reducer';

describe('Environment edit header form component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();

    const { saveForm, cancelForm } = environmentForm.actions;
    const beginState: RootState = {
        environmentForm: {
            saveEnabled: true,
            environmentModel: {
                description: '',
                folderId: '',
                id: '',
                labels: [],
                stage: {},
                title: '',
            },
        },
    };
    const environment1 = 'Environment1';

    const stateWithEnv: RootState = {
        environmentForm: {
            saveEnabled: true,
            environmentModel: {
                description: 'env1',
                folderId: '',
                id: '',
                labels: [],
                stage: {},
                title: environment1,
            },
        },
    };
    const mount = (appState: RootState = beginState, folderId = '', environmentId = '') => {
        wrapper = mountComponentWithStore(<EnvironmentEditHeaderComponent {...{ environmentId, folderId }} />, dispatch, { ...appState });
    };

    beforeEach(() => {
        preparePortalContainer();
        mount();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should handle properly callbacks', () => {
        const portal = wrapper.find('ActionToolbarPortalContainer');
        expect(portal.prop('helpLink')).toContain('how-to/using-environments');

        const cancelButton = portal.find('button').first();
        expect(cancelButton.exists()).toBeTruthy();
        cancelButton.simulate('click');
        expect(dispatch).toHaveBeenCalledTimes(1);
        expect(dispatch).toBeCalledWith(cancelForm(''));
        const saveButton = wrapper.find('button').at(1);
        expect(saveButton.exists()).toBeTruthy();
        saveButton.simulate('click');
        expect(dispatch).toBeCalledWith(saveForm(beginState.environmentForm.environmentModel));
    });

    it('should render properly on save', () => {
        const saveButton = wrapper.find('ActionToolbarPortalContainer button').at(1);
        expect(saveButton.text()).toBe('Create');
        expect(saveButton.prop('disabled')).toBeFalsy();
    });

    it('should render properly on update', () => {
        mount(stateWithEnv, '', environment1);
        const saveButton = wrapper.find('ActionToolbarPortalContainer button').at(1);
        expect(saveButton.text()).toBe('Save');
    });

    it('should render properly when disabled', () => {
        mount(
            {
                ...stateWithEnv,
                environmentForm: {
                    saveEnabled: false,
                },
            },
            '',
            environment1,
        );
        const saveButton = wrapper.find('ActionToolbarPortalContainer button').at(1);
        expect(saveButton.prop('disabled')).toBeTruthy();
    });
});
