/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentLabelFilters;
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel;
import com.xebialabs.xlrelease.environments.repository.EnvironmentLabelRepository;
import com.xebialabs.xlrelease.environments.service.package$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001\u0002\u0007\u000e\u0001aA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006]\u0001!\ta\f\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006w\u0002!\t\u0001 \u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!a\u0005\u0001\t\u0003\t)\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011Q\u0006\u0001\u0005\n\u0005=\"aF#om&\u0014xN\\7f]Rd\u0015MY3m'\u0016\u0014h/[2f\u0015\tqq\"A\u0004tKJ4\u0018nY3\u000b\u0005A\t\u0012\u0001D3om&\u0014xN\\7f]R\u001c(B\u0001\n\u0014\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0015+\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002-\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!G\u0010\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\t\u0001S%D\u0001\"\u0015\t\u00113%A\u0003tY\u001a$$NC\u0001%\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0014\"\u0005\u001daunZ4j]\u001e\f!$\u001a8wSJ|g.\\3oi2\u000b'-\u001a7SKB|7/\u001b;pef\u0004\"!\u000b\u0017\u000e\u0003)R!aK\b\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002.U\tQRI\u001c<je>tW.\u001a8u\u0019\u0006\u0014W\r\u001c*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"\"\u0001\r\u001a\u0011\u0005E\u0002Q\"A\u0007\t\u000b\u001d\u0012\u0001\u0019\u0001\u0015)\u0005\t!\u0004CA\u001bA\u001b\u00051$BA\u001c9\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003si\nqAZ1di>\u0014\u0018P\u0003\u0002<y\u0005)!-Z1og*\u0011QHP\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq(A\u0002pe\u001eL!!\u0011\u001c\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001D:fCJ\u001c\u0007\u000eT1cK2\u001cHC\u0001#T!\r)%\nT\u0007\u0002\r*\u0011q\tS\u0001\u0005kRLGNC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-3%\u0001\u0002'jgR\u0004\"!T)\u000e\u00039S!\u0001E(\u000b\u0005A\u000b\u0012A\u00023p[\u0006Lg.\u0003\u0002S\u001d\n\u0001RI\u001c<je>tW.\u001a8u\u0019\u0006\u0014W\r\u001c\u0005\u0006)\u000e\u0001\r!V\u0001\u0018K:4\u0018N]8o[\u0016tG\u000fT1cK24\u0015\u000e\u001c;feN\u0004\"AV/\u000e\u0003]S!\u0001W-\u0002\r\u0019LG\u000e^3s\u0015\tQ6,\u0001\u0002wc)\u0011A,E\u0001\u0004CBL\u0017B\u00010X\u0005])eN^5s_:lWM\u001c;MC\n,GNR5mi\u0016\u00148\u000f\u000b\u0002\u0004AB\u0011\u0011-[\u0007\u0002E*\u0011qg\u0019\u0006\u0003I\u0016\fAaY8sK*\u0011amZ\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(\"\u00015\u0002\u0005%|\u0017B\u00016c\u0005\u0015!\u0016.\\3e\u000351\u0017N\u001c3MC\n,GNQ=JIR\u0011A*\u001c\u0005\u0006]\u0012\u0001\ra\\\u0001\u0013K:4\u0018N]8o[\u0016tG\u000fT1cK2LE\r\u0005\u0002qo:\u0011\u0011/\u001e\t\u0003eni\u0011a\u001d\u0006\u0003i^\ta\u0001\u0010:p_Rt\u0014B\u0001<\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011\u00010\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\\\u0002F\u0001\u0003a\u0003-1\u0017N\u001c3CsRKG\u000f\\3\u0015\u00051k\b\"\u0002@\u0006\u0001\u0004y\u0017aD3om&\u0014xN\\7f]Rt\u0015-\\3)\u0005\u0015\u0001\u0017aC2sK\u0006$X\rT1cK2$2\u0001TA\u0003\u0011\u0019\t9A\u0002a\u0001\u0019\u0006\u0001RM\u001c<je>tW.\u001a8u\u0019\u0006\u0014W\r\u001c\u0015\u0003\r\u0001\f1\"\u001e9eCR,G*\u00192fYR\u0019A*a\u0004\t\r\u0005\u001dq\u00011\u0001MQ\t9\u0001-A\u0006eK2,G/\u001a'bE\u0016dG\u0003BA\f\u0003;\u00012AGA\r\u0013\r\tYb\u0007\u0002\u0005+:LG\u000fC\u0003o\u0011\u0001\u0007q\u000e\u000b\u0002\tA\u0006Aa/\u00197jI\u0006$X\r\u0006\u0003\u0002\u0018\u0005\u0015\u0002BBA\u0004\u0013\u0001\u0007A*A\u0007wC2LG-\u0019;f)&$H.\u001a\u000b\u0005\u0003/\tY\u0003\u0003\u0004\u0002\b)\u0001\r\u0001T\u0001\u000em\u0006d\u0017\u000eZ1uK\u000e{Gn\u001c:\u0015\t\u0005]\u0011\u0011\u0007\u0005\u0007\u0003gY\u0001\u0019A8\u0002\u000b\r|Gn\u001c:)\u0007\u0001\t9\u0004\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti\u0004P\u0001\u000bgR,'/Z8usB,\u0017\u0002BA!\u0003w\u0011qaU3sm&\u001cW\r")
public class EnvironmentLabelService
implements Logging {
    private final EnvironmentLabelRepository environmentLabelRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentLabelService environmentLabelService = this;
        synchronized (environmentLabelService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public List<EnvironmentLabel> searchLabels(EnvironmentLabelFilters environmentLabelFilters) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.environmentLabelRepository.search(environmentLabelFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public EnvironmentLabel findLabelById(String environmentLabelId) {
        return this.environmentLabelRepository.findById(environmentLabelId);
    }

    @Timed
    public EnvironmentLabel findByTitle(String environmentName) {
        return this.environmentLabelRepository.findByTitle(environmentName);
    }

    @Timed
    public EnvironmentLabel createLabel(EnvironmentLabel environmentLabel) {
        this.logger().debug((Function0 & Serializable)() -> "Creating a new environment label");
        this.validate(environmentLabel);
        return this.environmentLabelRepository.create(environmentLabel);
    }

    @Timed
    public EnvironmentLabel updateLabel(EnvironmentLabel environmentLabel) {
        this.logger().debug((Function0 & Serializable)() -> "Updating environment label [" + environmentLabel + "]");
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentLabel.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environmentLabel);
        return this.environmentLabelRepository.update(environmentLabel);
    }

    @Timed
    public void deleteLabel(String environmentLabelId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting environment label [" + environmentLabelId + "]");
        this.environmentLabelRepository.delete(environmentLabelId);
    }

    private void validate(EnvironmentLabel environmentLabel) {
        this.validateTitle(environmentLabel);
        this.validateColor(environmentLabel.getColor());
    }

    private void validateTitle(EnvironmentLabel environmentLabel) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentLabel.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    private void validateColor(String color) {
        if (!Pattern.compile("^#([A-Fa-f0-9]{6})$").matcher(color).matches()) {
            throw new Checks.IncorrectArgumentException("Invalid color pattern '" + color + "'", new Object[0]);
        }
    }

    @Autowired
    public EnvironmentLabelService(EnvironmentLabelRepository environmentLabelRepository) {
        this.environmentLabelRepository = environmentLabelRepository;
        Logging.$init$((Logging)this);
    }
}

