import { PayloadAction, createSlice } from '@reduxjs/toolkit';
import { Environment, EnvironmentEdit, EnvironmentForm } from '../../../application-list.types';
import noop from 'lodash/noop';

export const initialState: EnvironmentForm = {
    environmentModel: {
        description: '',
        folderId: null,
        id: '',
        labels: [],
        stage: {
            id: '',
            title: '',
        },
        title: '',
    },
    saveEnabled: false,
};

export const environmentForm = createSlice({
    name: 'environmentForm',
    initialState,
    reducers: {
        cancelForm: (_state: EnvironmentForm, _action: PayloadAction<string>) => noop(),
        initForm: (_state: EnvironmentForm, _action: PayloadAction<EnvironmentEdit>) => noop(),
        pristineFormChanged: (_state: EnvironmentForm, _action: PayloadAction<boolean>) => noop(),
        saveForm: (_state: EnvironmentForm, _action: PayloadAction<Environment>) => noop(),
        setEnvironmentModel: (state: EnvironmentForm, action: PayloadAction<Environment>) => {
            state.environmentModel = action.payload;
        },
        setSaveEnabled: (state: EnvironmentForm, action: PayloadAction<boolean>) => {
            state.saveEnabled = action.payload;
        },
    },
});
