import React from 'react';
import { mountComponentWithStore, preparePortalContainer } from '@xlr-ui/tests/unit/testing-utils';
import { StageListComponent } from './stage-list-component';
import { stages } from '../__mocks__/environment-list.mocks';
import { StageListHeaderComponent } from './stage-list-header-component';
import { StageEditModal } from './stage-edit-modal';
import { shallow } from 'enzyme';
import { StagePage } from './stage-page';

describe('Stage page', () => {
    const dummyState = {
        stageState: {
            stageList: stages,
        },
    };
    const dispatch = jest.fn();

    beforeEach(() => {
        preparePortalContainer();
    });

    it('should load page', () => {
        const page = shallow(<StagePage />);
        expect(page).toExist();
    });

    it('should render container', () => {
        const environmentPage = mountComponentWithStore(<StageListComponent />, dispatch, dummyState);
        const container = environmentPage.find(StageListComponent);
        expect(container.exists()).toBeTruthy();
        expect(environmentPage.find(StageListHeaderComponent)).toExist();
        expect(environmentPage.find(StageEditModal)).toExist();
    });
});
