import { environmentLists, initialState } from './environment-list.reducer';
import { envList, envWithId, stage, stages } from '../__mocks__/environment-list.mocks';

const {
    setEnvironments,
    setStages,
    setLoading,
    setFilterStage,
    setFilterTitle,
    initEnvironmentList,
    searchEnvironments,
    createEnvironment,
    editEnvironment,
    deleteEnvironment,
} = environmentLists.actions;

describe('Environment list reducer', () => {
    it('should have initial state', () => {
        expect(environmentLists.name).toBe('environmentLists');
        expect(environmentLists.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    it('should set environment list', () => {
        const state = environmentLists.reducer(initialState, setEnvironments(envList));
        expect(state.environments).toMatchObject(envList);
    });

    it('should set stages', () => {
        const state = environmentLists.reducer(initialState, setStages(stages));
        expect(state.stages).toMatchObject(stages);
    });

    it('should set loading', () => {
        const loading = true;
        const state = environmentLists.reducer(initialState, setLoading(loading));
        expect(state.loading).toBe(loading);
    });

    it('should set filter', () => {
        const state = environmentLists.reducer(initialState, setFilterTitle('title'));
        const state1 = environmentLists.reducer(state, setFilterStage(stage));
        expect(state1.filters.stage).toMatchObject(stage);
        expect(state1.filters.title).toStrictEqual('title');
    });

    it('init should not update state', () => {
        const state = environmentLists.reducer(initialState, initEnvironmentList(''));
        expect(state).toStrictEqual(initialState);
    });

    it('search should not update state', () => {
        const state = environmentLists.reducer(initialState, searchEnvironments({ title: '', folderId: '', stageTitle: '' }));
        expect(state).toStrictEqual(initialState);
    });

    it('delete should not update state', () => {
        const state = environmentLists.reducer(initialState, deleteEnvironment(envWithId));
        expect(state).toStrictEqual(initialState);
    });

    it('create should not update state', () => {
        const state = environmentLists.reducer(initialState, createEnvironment(''));
        expect(state).toStrictEqual(initialState);
    });

    it('edit should not update state', () => {
        const state = environmentLists.reducer(initialState, editEnvironment({ envId: '1', folderId: '' }));
        expect(state).toStrictEqual(initialState);
    });
});
