package com.xebialabs.xlrelease.environments.events

import com.xebialabs.xlrelease.domain.environments.{Application, Environment, EnvironmentReservation}
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent

sealed trait EnvironmentEvent extends XLReleaseEvent

case class EnvironmentCreatedEvent(e: Environment) extends EnvironmentEvent
case class EnvironmentUpdatedEvent(e: Environment) extends EnvironmentEvent
case class EnvironmentDeletedEvent(e: Environment) extends EnvironmentEvent

sealed trait ApplicationEvent extends XLReleaseEvent

case class ApplicationCreatedEvent(e: Application) extends ApplicationEvent
case class ApplicationUpdatedEvent(e: Application) extends ApplicationEvent
case class ApplicationDeletedEvent(e: Application) extends ApplicationEvent

sealed trait EnvironmentReservationEvent extends XLReleaseEvent

case class EnvironmentReservationCreatedEvent(environmentReservation: EnvironmentReservation) extends EnvironmentReservationEvent
case class EnvironmentReservationUpdatedEvent(environmentReservation: EnvironmentReservation) extends EnvironmentReservationEvent
case class EnvironmentReservationDeletedEvent(environmentReservation: EnvironmentReservation) extends EnvironmentReservationEvent
