import noop from 'lodash/noop';
import { byTitle } from '../../../utils';
import { Application, ApplicationEdit, ApplicationList, ApplicationName } from '../../../application-list.types';
import { createSlice, PayloadAction } from '@reduxjs/toolkit';

export const initialState: ApplicationList = {
    applications: [],
    deleteModalIsOpen: false,
    applicationToDelete: {
        environments: [],
        folderId: '',
        id: '',
        title: '',
    },
};

export const applicationLists = createSlice({
    name: 'applicationLists',
    initialState,
    reducers: {
        setApplicationToDelete: (state: ApplicationList, action: PayloadAction<Application>) => {
            state.applicationToDelete = action.payload;
        },
        searchApplications: (_state: ApplicationList, _action: PayloadAction<ApplicationName>) => noop(),
        setApplications: (state: ApplicationList, action: PayloadAction<Array<Application>>) => {
            state.applications = action.payload.sort(byTitle);
        },
        deleteApplication: (_state: ApplicationList, _action: PayloadAction<Application>) => noop(),
        createApplication: (_state: ApplicationList, _action: PayloadAction<string>) => noop(),
        editApplication: (_state: ApplicationList, _action: PayloadAction<ApplicationEdit>) => noop(),
    },
});
